/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.opennms.osgi.EventRegistry;
import org.opennms.osgi.OnmsServiceManager;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextCreator;
import org.opennms.osgi.locator.EventRegistryLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsServiceManagerImpl
implements OnmsServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsServiceManagerImpl.class);
    private final Map<Object, ServiceRegistration<?>> serviceRegistrations = Collections.synchronizedMap(new HashMap());
    private final BundleContext bundleContext;

    public OnmsServiceManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public <T> void registerAsService(Class<T> serviceClass, T serviceBean, VaadinApplicationContext applicationContext) {
        this.registerAsService(serviceClass, serviceBean, applicationContext, new Hashtable<String, Object>());
    }

    @Override
    public <T> void registerAsService(Class<T> serviceClass, T serviceBean, VaadinApplicationContext applicationContext, Dictionary<String, Object> properties) {
        if (serviceBean == null || serviceClass == null) {
            return;
        }
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(serviceClass, serviceBean, this.getProperties(applicationContext, properties));
        this.serviceRegistrations.put(serviceBean, serviceRegistration);
    }

    @Override
    public EventRegistry getEventRegistry() {
        return new EventRegistryLocator().lookup(this.bundleContext);
    }

    @Override
    public <T> T getService(Class<T> clazz, VaadinApplicationContext applicationContext) {
        List<T> services = this.getServices(clazz, applicationContext, new Hashtable<String, Object>());
        if (services.isEmpty()) {
            return null;
        }
        return services.get(0);
    }

    @Override
    public <T> List<T> getServices(Class<T> clazz, VaadinApplicationContext applicationContext, Hashtable<String, Object> additionalProperties) {
        if (additionalProperties == null) {
            additionalProperties = new Hashtable();
        }
        ArrayList<Object> services = new ArrayList<Object>();
        try {
            Collection serviceReferences = this.bundleContext.getServiceReferences(clazz, this.getFilter(applicationContext, additionalProperties));
            if (serviceReferences != null) {
                for (ServiceReference eachServiceReference : serviceReferences) {
                    Object service = this.bundleContext.getService(eachServiceReference);
                    if (service == null) continue;
                    services.add(service);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Invalid Filter definition in getService()", (Throwable)e);
        }
        return services;
    }

    public void sessionInitialized(String sessionId) {
    }

    public void sessionDestroyed(String sessionId) {
        String sessionIdFilter = "(sessionId=%s)";
        try {
            ServiceReference[] allServiceReferences = this.bundleContext.getAllServiceReferences(null, String.format("(sessionId=%s)", sessionId));
            if (allServiceReferences != null) {
                for (ServiceReference eachReference : allServiceReferences) {
                    Object service = this.bundleContext.getService(eachReference);
                    if (service == null || this.serviceRegistrations.get(service) == null) continue;
                    this.serviceRegistrations.get(service).unregister();
                    this.serviceRegistrations.remove(service);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Error retrieving ServiceReferences", (Throwable)e);
        }
    }

    @Override
    public VaadinApplicationContext createApplicationContext(VaadinApplicationContextCreator creator) {
        VaadinApplicationContext newContext = creator.create(this);
        VaadinApplicationContext oldContext = this.getService(VaadinApplicationContext.class, newContext);
        if (oldContext != null) {
            return oldContext;
        }
        this.registerAsService(VaadinApplicationContext.class, newContext, newContext);
        return newContext;
    }

    private String getFilter(VaadinApplicationContext applicationContext, Hashtable<String, Object> additionalProperties) {
        if (applicationContext == null && additionalProperties.isEmpty()) {
            return null;
        }
        String filter = "(&%s%s)";
        String sessionFilter = "(sessionId=%s)(uiId=%s)";
        String additionalPropertiesFilterString = this.getAdditionalPropertiesString(additionalProperties);
        String sessionFilterString = applicationContext == null ? "" : String.format(sessionFilter, applicationContext.getSessionId(), Integer.toString(applicationContext.getUiId()));
        return String.format(filter, sessionFilterString, additionalPropertiesFilterString);
    }

    private String getAdditionalPropertiesString(Hashtable<String, Object> additionalProperties) {
        String returnString = "";
        if (!additionalProperties.isEmpty()) {
            for (Map.Entry<String, Object> eachEntry : additionalProperties.entrySet()) {
                returnString = returnString + "(" + eachEntry.getKey() + "=" + eachEntry.getValue() + ")";
            }
        }
        return returnString;
    }

    private Dictionary<String, Object> getProperties(VaadinApplicationContext applicationContext, Dictionary<String, Object> properties) {
        String sessionId;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        if ((sessionId = applicationContext.getSessionId()) != null && !sessionId.isEmpty()) {
            properties.put("sessionId", applicationContext.getSessionId());
        }
        if (applicationContext.getUiId() > -1) {
            properties.put("uiId", applicationContext.getUiId());
        }
        return properties;
    }
}

