/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi.locator;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLocator {
    private final Logger Log = LoggerFactory.getLogger(this.getClass());

    public <T> T lookup(Class<T> lookupClass, BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("BundleContext must not be null!");
        }
        if (lookupClass == null) {
            throw new IllegalArgumentException("LookupClass must not be null!");
        }
        try {
            ServiceReference[] serviceReferences = bundleContext.getAllServiceReferences(lookupClass.getName(), String.format("(bundleId=%d)", bundleContext.getBundle().getBundleId()));
            if (serviceReferences == null || serviceReferences.length == 0) {
                this.Log.warn("No {} found", lookupClass);
                return null;
            }
            return (T)bundleContext.getService(serviceReferences[0]);
        }
        catch (InvalidSyntaxException ex) {
            this.Log.warn(String.format("Error while retrieving %s", lookupClass), (Throwable)ex);
            this.Log.warn("No {} found", lookupClass);
            return null;
        }
    }
}

