/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventListener.class);
    private Object eventConsumer;
    private Method eventMethod;

    EventListener() {
    }

    public static Properties getProperties(Class<?> consumingType) {
        Properties properties = new Properties();
        properties.put(EventListener.class.getName() + ".consumingType", consumingType.getName());
        return properties;
    }

    public void setEventConsumer(Object eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public void setEventMethod(Method eventMethod) {
        this.eventMethod = eventMethod;
    }

    public void invoke(Object eventObject) {
        try {
            this.eventMethod.invoke(this.eventConsumer, eventObject);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error while invoking event consuming method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error while invoking event consuming method", (Throwable)e);
        }
    }
}

