/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2012 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2012 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.osgi;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * If you want an instance of a class to get notified when an event of a concrete type is fired, just add
 * this annotation to the method which consumes that event object. <br/><br/>
 * <b>Example:</b><br/>
 * <pre>
 *     // An event consumer
 *     class MyEventConsumer {
 *         //...
 *        &#64;EventConsumer
 *        public void eventTypeChanged(EventType eventType) {
 *            // do something..
 *        }
 *         //...
 *     }
 *
 *     // some event producer which publishes the event through the EventRegistry
 *     EventProducer producer = new EventProducer();
 *     producer.fireEvent(new EventType());
 * </pre>
 *
 * @see {@link EventRegistry}, {@link EventProxy}
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface EventConsumer {

}
