/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.icmp.proxy.IPRangeDTO;

@XmlRootElement(name="ping-sweep-request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PingSweepRequestDTO
implements RpcRequest {
    private static final BigDecimal FUDGE_FACTOR = BigDecimal.valueOf(1.5);
    @XmlElement(name="ip-range")
    private List<IPRangeDTO> ipRanges = new ArrayList<IPRangeDTO>();
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="packet-size")
    private Integer packetSize;
    @XmlAttribute(name="packets-per-second")
    private Double packetsPerSecond;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getPacketSize() {
        return this.packetSize != null ? this.packetSize : 64;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public double getPacketsPerSecond() {
        return this.packetsPerSecond != null ? this.packetsPerSecond : 1.0;
    }

    public void setPacketsPerSecond(double packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
    }

    public List<IPRangeDTO> getIpRanges() {
        return this.ipRanges;
    }

    public void addIpRange(IPRangeDTO range) {
        this.ipRanges.add(range);
    }

    public void setIpRanges(List<IPRangeDTO> ipRanges) {
        this.ipRanges = ipRanges;
    }

    public int hashCode() {
        return Objects.hash(this.ipRanges, this.location, this.packetSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PingSweepRequestDTO other = (PingSweepRequestDTO)obj;
        return Objects.equals(this.ipRanges, other.ipRanges) && Objects.equals(this.location, other.location) && Objects.equals(this.packetSize, other.packetSize) && Objects.equals(this.packetsPerSecond, other.packetsPerSecond);
    }

    public Long getTimeToLiveMs() {
        BigDecimal taskTimeOut = BigDecimal.ZERO;
        for (IPRangeDTO range : this.ipRanges) {
            BigInteger size = InetAddressUtils.difference((InetAddress)InetAddressUtils.getInetAddress((byte[])range.getEnd().getAddress()), (InetAddress)InetAddressUtils.getInetAddress((byte[])range.getBegin().getAddress())).add(BigInteger.ONE);
            taskTimeOut = taskTimeOut.add(BigDecimal.valueOf(range.getRetries()).add(BigDecimal.ONE, MathContext.DECIMAL64).multiply(new BigDecimal(size), MathContext.DECIMAL64).multiply(BigDecimal.valueOf(range.getTimeout()), MathContext.DECIMAL64).multiply(FUDGE_FACTOR, MathContext.DECIMAL64), MathContext.DECIMAL64);
            taskTimeOut = taskTimeOut.add(new BigDecimal(size).divide(BigDecimal.valueOf(this.getPacketsPerSecond()), MathContext.DECIMAL64).multiply(BigDecimal.valueOf(1000L), MathContext.DECIMAL64), MathContext.DECIMAL64);
        }
        return taskTimeOut.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) >= 0 ? Long.MAX_VALUE : taskTimeOut.longValue();
    }
}

