/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.core.utils.IteratorUtils;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.icmp.proxy.IPRangeDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResultDTO;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PingSweepRpcModule
extends AbstractXmlRpcModule<PingSweepRequestDTO, PingSweepResponseDTO> {
    public static final String RPC_MODULE_ID = "PING-SWEEP";
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ping-sweep-%d").build();
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    @Autowired
    private PingerFactory pingerFactory;

    public PingSweepRpcModule() {
        super(PingSweepRequestDTO.class, PingSweepResponseDTO.class);
    }

    public CompletableFuture<PingSweepResponseDTO> execute(PingSweepRequestDTO request) {
        Pinger pinger = this.pingerFactory.getInstance();
        PingSweepResultTracker tracker = new PingSweepResultTracker();
        String location = request.getLocation();
        int packetSize = request.getPacketSize();
        ArrayList<IPPollRange> ranges = new ArrayList<IPPollRange>();
        for (IPRangeDTO dto : request.getIpRanges()) {
            IPPollRange pollRange = new IPPollRange(null, location, dto.getBegin(), dto.getEnd(), dto.getTimeout(), dto.getRetries());
            ranges.add(pollRange);
        }
        RateLimiter limiter = RateLimiter.create((double)request.getPacketsPerSecond());
        List addresses = StreamSupport.stream(this.getAddresses(ranges).spliterator(), false).filter(j -> j.getAddress() != null).collect(Collectors.toList());
        return CompletableFuture.supplyAsync(() -> {
            addresses.stream().forEach(pollAddress -> {
                try {
                    tracker.expectCallbackFor(pollAddress.getAddress());
                    limiter.acquire();
                    pinger.ping(pollAddress.getAddress(), pollAddress.getTimeout(), pollAddress.getRetries(), packetSize, 1, (PingResponseCallback)tracker);
                }
                catch (Exception e) {
                    tracker.handleError(pollAddress.getAddress(), null, e);
                    tracker.completeExceptionally(e);
                }
            });
            try {
                tracker.getLatch().await();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            tracker.complete();
            return tracker.getResponse();
        }, this.executor);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public void setPingerFactory(PingerFactory pingerFactory) {
        this.pingerFactory = pingerFactory;
    }

    public Iterable<IPPollAddress> getAddresses(List<IPPollRange> ranges) {
        ArrayList<Iterator> iters = new ArrayList<Iterator>();
        for (IPPollRange range : ranges) {
            iters.add(range.iterator());
        }
        return IteratorUtils.concatIterators(iters);
    }

    private static class PingSweepResultTracker
    extends CompletableFuture<PingSweepResponseDTO>
    implements PingResponseCallback {
        private final Set<InetAddress> waitingFor = Sets.newConcurrentHashSet();
        private final CountDownLatch m_doneSignal = new CountDownLatch(1);
        private final PingSweepResponseDTO responseDTO = new PingSweepResponseDTO();

        private PingSweepResultTracker() {
        }

        public void expectCallbackFor(InetAddress address) {
            this.waitingFor.add(address);
        }

        public void handleResponse(InetAddress address, EchoPacket response) {
            if (response != null) {
                PingSweepResultDTO sweepResult = new PingSweepResultDTO();
                sweepResult.setAddress(address);
                sweepResult.setRtt(response.elapsedTime(TimeUnit.MILLISECONDS));
                this.responseDTO.addPingSweepResult(sweepResult);
            }
            this.afterHandled(address);
        }

        public void handleTimeout(InetAddress address, EchoPacket request) {
            this.afterHandled(address);
        }

        public void handleError(InetAddress address, EchoPacket request, Throwable t) {
            this.afterHandled(address);
        }

        private void afterHandled(InetAddress address) {
            this.waitingFor.remove(address);
            if (this.waitingFor.isEmpty()) {
                this.m_doneSignal.countDown();
            }
        }

        public void complete() {
            this.complete(this.responseDTO);
        }

        public PingSweepResponseDTO getResponse() {
            return this.responseDTO;
        }

        public CountDownLatch getLatch() {
            return this.m_doneSignal;
        }
    }
}

