/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingResultTracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PingProxyRpcModule
extends AbstractXmlRpcModule<PingRequestDTO, PingResponseDTO> {
    public static final String RPC_MODULE_ID = "PING";
    @Autowired
    private PingerFactory pingerFactory;

    public PingProxyRpcModule() {
        super(PingRequestDTO.class, PingResponseDTO.class);
    }

    public CompletableFuture<PingResponseDTO> execute(PingRequestDTO request) {
        PingResultTracker tracker = new PingResultTracker();
        try {
            this.pingerFactory.getInstance().ping(request.getInetAddress(), request.getTimeout(), request.getRetries(), request.getPacketSize(), 1, (PingResponseCallback)tracker);
        }
        catch (Exception e) {
            tracker.completeExceptionally(e);
        }
        return tracker;
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public void setPingerFactory(PingerFactory pingerFactory) {
        this.pingerFactory = pingerFactory;
    }
}

