/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.DiscoveryPingResponseCallback;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@EventListener(name="OpenNMS.Discovery", logPrefix="discovery")
public class Discovery
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Discovery.class);
    private static final DiscoveryPingResponseCallback cb = new DiscoveryPingResponseCallback();
    private static final String LOG4J_CATEGORY = "discovery";
    private static final int PING_IDLE = 0;
    private static final int PING_RUNNING = 1;
    private static final int PING_FINISHING = 2;
    private static final String ALL_IP_ADDRS_SQL = "SELECT DISTINCT ipAddr FROM ipInterface WHERE isManaged <> 'D'";
    private Set<String> m_alreadyDiscovered = Collections.synchronizedSet(new HashSet());
    private DiscoveryConfigFactory m_discoveryFactory;
    private Timer m_timer;
    private int m_xstatus = 0;
    private volatile EventForwarder m_eventForwarder;
    private Pinger m_pinger;

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void setPinger(Pinger pinger) {
        this.m_pinger = pinger;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setDiscoveryFactory(DiscoveryConfigFactory discoveryFactory) {
        this.m_discoveryFactory = discoveryFactory;
    }

    public DiscoveryConfigFactory getDiscoveryFactory() {
        return this.m_discoveryFactory;
    }

    public Discovery() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() throws IllegalStateException {
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        Assert.state((this.m_discoveryFactory != null ? 1 : 0) != 0, (String)"must set the Discovery Factory property");
        cb.setDiscoveryFactory(this.m_discoveryFactory);
        try {
            LOG.debug("Initializing configuration...");
            this.initializeConfiguration();
            LOG.debug("Configuration initialized.  Init the factory...");
            EventIpcManagerFactory.init();
            LOG.debug("Factory init'd.");
        }
        catch (Throwable e) {
            LOG.debug("onInit: initialization failed", e);
            throw new IllegalStateException("Could not initialize discovery configuration.", e);
        }
    }

    private void initializeConfiguration() throws MarshalException, ValidationException, IOException {
        this.m_discoveryFactory.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPings() {
        LOG.info("starting ping sweep");
        try {
            this.initializeConfiguration();
        }
        catch (Throwable e) {
            LOG.error("doPings: could not re-init configuration, continuing with in memory configuration.", e);
        }
        this.m_xstatus = 1;
        this.getDiscoveryFactory().getReadLock().lock();
        try {
            for (IPPollAddress pollAddress : this.getDiscoveryFactory().getConfiguredAddresses()) {
                if (this.m_xstatus == 2 || this.m_timer == null) {
                    this.m_xstatus = 0;
                    return;
                }
                LOG.debug("Pinging: {} of foreign source {}", (Object)pollAddress.getAddress().toString(), (Object)this.m_discoveryFactory.getForeignSource(pollAddress.getAddress()));
                this.ping(pollAddress);
                try {
                    Thread.sleep(this.getDiscoveryFactory().getIntraPacketDelay());
                }
                catch (InterruptedException e) {
                    LOG.info("interrupting discovery sweep");
                    break;
                }
            }
        }
        finally {
            this.getDiscoveryFactory().getReadLock().unlock();
        }
        LOG.info("finished discovery sweep");
        this.m_xstatus = 0;
    }

    private void ping(IPPollAddress pollAddress) {
        InetAddress address = pollAddress.getAddress();
        if (address != null) {
            if (!this.isAlreadyDiscovered(address)) {
                try {
                    this.m_pinger.ping(address, pollAddress.getTimeout(), pollAddress.getRetries(), 1, (PingResponseCallback)cb);
                }
                catch (Throwable e) {
                    LOG.debug("error pinging {}", (Object)address.getAddress(), (Object)e);
                }
            } else {
                LOG.debug("{} already discovered.", (Object)address.toString());
            }
        }
    }

    private boolean isAlreadyDiscovered(InetAddress address) {
        return this.m_alreadyDiscovered.contains(InetAddressUtils.str((InetAddress)address));
    }

    private void startTimer() {
        if (this.m_timer != null) {
            LOG.debug("startTimer() called, but a previous timer exists; making sure it's cleaned up");
            this.m_xstatus = 2;
            this.m_timer.cancel();
        }
        LOG.debug("scheduling new discovery timer");
        this.m_timer = new Timer("Discovery.Pinger", true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Discovery.this.doPings();
            }
        };
        Lock readLock = this.getDiscoveryFactory().getReadLock();
        readLock.lock();
        try {
            this.m_timer.scheduleAtFixedRate(task, this.getDiscoveryFactory().getInitialSleepTime(), this.getDiscoveryFactory().getRestartSleepTime());
        }
        finally {
            readLock.unlock();
        }
    }

    private void stopTimer() {
        if (this.m_timer != null) {
            LOG.debug("stopping existing timer");
            this.m_xstatus = 2;
            this.m_timer.cancel();
            this.m_timer = null;
        } else {
            LOG.debug("stopTimer() called, but there is no existing timer");
        }
    }

    protected void onStart() {
        this.syncAlreadyDiscovered();
        this.startTimer();
    }

    protected void onStop() {
        this.stopTimer();
    }

    protected void onPause() {
        this.stopTimer();
    }

    protected void onResume() {
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAlreadyDiscovered() {
        Set<String> newAlreadyDiscovered = Collections.synchronizedSet(new HashSet());
        Connection conn = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(ALL_IP_ADDRS_SQL);
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs != null) {
                while (rs.next()) {
                    newAlreadyDiscovered.add(rs.getString(1));
                }
            } else {
                LOG.warn("Got null ResultSet from query for all IP addresses");
            }
            this.m_alreadyDiscovered = newAlreadyDiscovered;
        }
        catch (SQLException sqle) {
            LOG.warn("Caught SQLException while trying to query for all IP addresses: {}", (Object)sqle.getMessage());
        }
        finally {
            d.cleanUp();
        }
        LOG.info("syncAlreadyDiscovered initialized list of managed IP addresses with {} members", (Object)this.m_alreadyDiscovered.size());
    }

    @EventHandler(uei="uei.opennms.org/internal/discoveryConfigChange")
    public void handleDiscoveryConfigurationChanged(Event event) {
        LOG.info("handleDiscoveryConfigurationChanged: handling message that a change to configuration happened...");
        this.reloadAndReStart();
    }

    private void reloadAndReStart() {
        EventBuilder ebldr = null;
        try {
            this.initializeConfiguration();
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            this.stop();
            this.start();
        }
        catch (MarshalException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (ValidationException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (IOException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.m_eventForwarder.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void reloadDaemonConfig(Event e) {
        LOG.info("reloadDaemonConfig: processing reload daemon event...");
        if (this.isReloadConfigEventTarget(e)) {
            this.reloadAndReStart();
        }
        LOG.info("reloadDaemonConfig: reload daemon event processed.");
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Discovery".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: discovery was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeleted(Event event) {
        if (event.getInterface() != null) {
            String iface = event.getInterface();
            this.m_alreadyDiscovered.remove(iface);
            LOG.debug("Removed {} from known node list", (Object)iface);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discResume")
    public void handleDiscoveryResume(Event event) {
        try {
            this.resume();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discPause")
    public void handleDiscoveryPause(Event event) {
        try {
            this.pause();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedInterface")
    public void handleNodeGainedInterface(Event event) {
        String iface = event.getInterface();
        this.m_alreadyDiscovered.add(iface);
        LOG.debug("Added {} as discovered", (Object)iface);
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

