/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.FileSystemSaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.JaxbToJsonStore;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThresholdingDao;
import org.opennms.netmgt.config.dao.thresholding.impl.AbstractThresholdingDao;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

public class OnmsThresholdingDao
extends AbstractThresholdingDao
implements WriteableThresholdingDao,
JaxbToJsonStore<ThresholdingConfig> {
    private final SaveableConfigContainer<ThresholdingConfig> saveableConfigContainer;

    @VisibleForTesting
    OnmsThresholdingDao(JsonStore jsonStore, File configFile) {
        super(jsonStore);
        Objects.requireNonNull(configFile);
        this.saveableConfigContainer = new FileSystemSaveableConfigContainer(ThresholdingConfig.class, "thresholds", Collections.singleton(this.getJsonWriterCallbackFunction(jsonStore, "thresholds", "config")), configFile);
        this.reload();
    }

    public OnmsThresholdingDao(JsonStore jsonStore) throws IOException {
        this(jsonStore, ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME));
    }

    public void saveConfig() {
        this.saveableConfigContainer.saveConfig();
    }

    public ThresholdingConfig getConfig() {
        return (ThresholdingConfig)this.saveableConfigContainer.getConfig();
    }

    @Override
    public void reload() {
        this.saveableConfigContainer.reload();
        super.reload();
    }
}

