/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.FileSystemSaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.JaxbToJsonStore;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.impl.AbstractThreshdDao;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;

public class OnmsThreshdDao
extends AbstractThreshdDao
implements WriteableThreshdDao,
JaxbToJsonStore<ThreshdConfiguration> {
    private final SaveableConfigContainer<ThreshdConfiguration> saveableConfigContainer;

    @VisibleForTesting
    OnmsThreshdDao(JsonStore jsonStore, File configFile) {
        super(jsonStore);
        Objects.requireNonNull(configFile);
        this.saveableConfigContainer = new FileSystemSaveableConfigContainer(ThreshdConfiguration.class, "threshd-configuration", Collections.singleton(this.getJsonWriterCallbackFunction(jsonStore, "threshd-configuration", "config")), configFile);
        this.reload();
    }

    public OnmsThreshdDao(JsonStore jsonStore) throws IOException {
        this(jsonStore, ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME));
    }

    public ThreshdConfiguration getConfig() {
        return (ThreshdConfiguration)this.saveableConfigContainer.getConfig();
    }

    @Override
    public void reload() {
        this.saveableConfigContainer.reload();
        super.reload();
    }

    public void saveConfig() {
        this.saveableConfigContainer.saveConfig();
    }
}

