/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThresholdingDao;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

public abstract class AbstractThresholdingDao
implements ReadableThresholdingDao {
    private final Map<String, Group> groupMap = new HashMap<String, Group>();
    final JsonStore jsonStore;
    public static final String JSON_STORE_KEY = "thresholds";

    AbstractThresholdingDao() {
        this.jsonStore = null;
        this.reload();
    }

    AbstractThresholdingDao(JsonStore jsonStore) {
        this.jsonStore = Objects.requireNonNull(jsonStore);
    }

    public void reload() {
        this.initGroupMap();
    }

    public String getRrdRepository(String groupName) {
        return this.getGroup(groupName).getRrdRepository();
    }

    public synchronized Group getGroup(String groupName) {
        Group group = this.groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public Collection<Basethresholddef> getThresholds(String groupName) {
        Group group = this.getGroup(groupName);
        ArrayList<Basethresholddef> result = new ArrayList<Basethresholddef>();
        result.addAll(group.getThresholds());
        result.addAll(group.getExpressions());
        return result;
    }

    public synchronized Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.groupMap.keySet());
    }

    synchronized void initGroupMap() {
        ThresholdingConfig thresholdingConfig = (ThresholdingConfig)this.getConfig();
        if (thresholdingConfig != null) {
            for (Group g : ((ThresholdingConfig)this.getConfig()).getGroups()) {
                this.groupMap.put(g.getName(), g);
            }
        }
    }
}

