/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;

public class XmpConfigFactory {
    private static XmpConfigFactory instance;
    private static boolean loadedFromFile;
    private static boolean initialized;
    private XmpConfig config = null;

    public static void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.XMP_CONFIG_FILE_NAME);
            instance = new XmpConfigFactory(cfgFile.getPath());
            loadedFromFile = true;
            initialized = true;
        }
    }

    public XmpConfig getXmpConfig() {
        return this.config;
    }

    public static XmpConfigFactory getInstance() {
        return instance;
    }

    public XmpConfigFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.config = (XmpConfig)Unmarshaller.unmarshal(XmpConfig.class, (Reader)new InputStreamReader((InputStream)cfgIn, "UTF-8"));
        ((InputStream)cfgIn).close();
    }

    public XmpConfigFactory(Reader rdr) throws MarshalException, ValidationException, IOException {
        this.config = (XmpConfig)Unmarshaller.unmarshal(XmpConfig.class, (Reader)rdr);
    }

    static {
        loadedFromFile = false;
        initialized = false;
    }
}

