/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.WsManAssetAdapterConfig;
import org.opennms.netmgt.config.wsmanAsset.adapter.AssetField;
import org.opennms.netmgt.config.wsmanAsset.adapter.Package;
import org.opennms.netmgt.config.wsmanAsset.adapter.WsManAssetAdapterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsManAssetAdapterConfigManager
implements WsManAssetAdapterConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WsManAssetAdapterConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private long m_lastModified;
    private WsManAssetAdapterConfiguration m_config;

    public WsManAssetAdapterConfigManager() {
    }

    public WsManAssetAdapterConfigManager(long lastModified, InputStream reader) throws IOException {
        this.reloadXML(lastModified, reader);
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(long lastModified, InputStream stream) throws IOException {
        this.getWriteLock().lock();
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_config = (WsManAssetAdapterConfiguration)JaxbUtils.unmarshal(WsManAssetAdapterConfiguration.class, (Reader)reader);
            this.m_lastModified = lastModified;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws IOException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WSMAN_ASSET_ADAPTER_CONFIG_FILE_NAME);
            long lastModified = cfgFile.lastModified();
            if (lastModified > this.m_lastModified) {
                LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
                this.reloadXML(lastModified, new FileInputStream(cfgFile));
                LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected WsManAssetAdapterConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            WsManAssetAdapterConfiguration wsManAssetAdapterConfiguration = this.m_config;
            return wsManAssetAdapterConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetField[] getAssetFieldsForAddress(InetAddress address, String vendor) {
        this.getReadLock().lock();
        try {
            if (vendor == null) {
                LOG.debug("getAssetFieldsForAddress: WSMAN vendor field was null for address {}, returning empty list", (Object)InetAddressUtils.str((InetAddress)address));
                AssetField[] assetFieldArray = new AssetField[]{};
                return assetFieldArray;
            }
            ArrayList retval = new ArrayList();
            for (Package pkg : this.m_config.getPackages()) {
                String pkgVendor = pkg.getVendor();
                if (pkgVendor == null || !pkgVendor.equals(vendor)) continue;
                retval.addAll(pkg.getAssetFields());
            }
            if (retval.isEmpty()) {
                LOG.debug("getAssetFieldsForAddress: Zero AssetField matches returned for {} with vendor: {}", (Object)InetAddressUtils.str((InetAddress)address), (Object)vendor);
            }
            AssetField[] assetFieldArray = retval.toArray(new AssetField[0]);
            return assetFieldArray;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

