/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.AbstractTimeIntervalSequence;
import org.opennms.core.utils.OwnedInterval;
import org.opennms.core.utils.OwnedIntervalSequence;
import org.opennms.core.utils.Owner;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.api.GroupConfig;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Groupinfo;
import org.opennms.netmgt.config.groups.Header;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupManager
implements GroupConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GroupManager.class);
    protected static Map<String, List<DutySchedule>> m_dutySchedules = new HashMap<String, List<DutySchedule>>();
    private Map<String, Group> m_groups = new HashMap<String, Group>();
    private Map<String, Role> m_roles = new HashMap<String, Role>();
    private Header m_oldHeader;

    protected synchronized void parseXml(InputStream stream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream);){
            Groupinfo groupinfo = (Groupinfo)JaxbUtils.unmarshal(Groupinfo.class, (Reader)isr);
            this.initializeGroupsAndRoles(groupinfo);
        }
    }

    private void initializeGroupsAndRoles(Groupinfo groupinfo) {
        List groups = groupinfo.getGroups();
        this.m_groups = new LinkedHashMap<String, Group>();
        this.m_oldHeader = groupinfo.getHeader();
        for (Group curGroup : groups) {
            this.m_groups.put(curGroup.getName(), curGroup);
        }
        GroupManager.buildDutySchedules(this.m_groups);
        if (groupinfo.getRoles().size() > 0) {
            this.m_roles = new LinkedHashMap<String, Role>();
            for (Role role : groupinfo.getRoles()) {
                this.m_roles.put(role.getName(), role);
            }
        }
    }

    public void setGroups(Map<String, Group> grp) {
        this.m_groups = grp;
    }

    public Map<String, Group> getGroups() throws IOException {
        this.update();
        return Collections.unmodifiableMap(this.m_groups);
    }

    public OnmsGroupList getOnmsGroupList() throws IOException {
        return new OnmsGroupListMapper().map(new OnmsGroupMapper().map(this.getGroups().values()));
    }

    public OnmsGroup getOnmsGroup(String groupName) throws IOException {
        Group xmlGroup = this.getGroup(groupName);
        if (xmlGroup == null) {
            return null;
        }
        return new OnmsGroupMapper().map(xmlGroup);
    }

    public synchronized void save(OnmsGroup group) throws Exception {
        Group xmlGroup = this.getGroup(group.getName());
        if (xmlGroup == null) {
            xmlGroup = new Group();
            xmlGroup.setName(group.getName());
        }
        xmlGroup.setComments(group.getComments());
        xmlGroup.setUsers(group.getUsers());
        this.saveGroup(group.getName(), xmlGroup);
    }

    public abstract void update() throws IOException;

    public boolean hasGroup(String groupName) throws IOException {
        this.update();
        return this.m_groups.containsKey(groupName);
    }

    public List<String> getGroupNames() throws IOException {
        this.update();
        return new ArrayList<String>(this.m_groups.keySet());
    }

    public Group getGroup(String name) throws IOException {
        this.update();
        return this.m_groups.get(name);
    }

    public synchronized void saveGroups() throws Exception {
        Header header = this.m_oldHeader;
        if (header != null) {
            header.setCreated(EventConstants.formatToString((Date)new Date()));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.m_groups.values()) {
            groups.add(group);
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role role : this.m_roles.values()) {
            roles.add(role);
        }
        Groupinfo groupinfo = new Groupinfo();
        groupinfo.setGroups(groups);
        groupinfo.setRoles(roles);
        groupinfo.setHeader(header);
        this.m_oldHeader = header;
        StringWriter stringWriter = new StringWriter();
        JaxbUtils.marshal((Object)groupinfo, (Writer)stringWriter);
        String data = stringWriter.toString();
        this.saveXml(data);
    }

    private static void buildDutySchedules(Map<String, Group> groups) {
        m_dutySchedules = new HashMap<String, List<DutySchedule>>();
        for (Map.Entry<String, Group> entry : groups.entrySet()) {
            String key = entry.getKey();
            Group curGroup = entry.getValue();
            if (curGroup.getDutySchedules().size() <= 0) continue;
            ArrayList<DutySchedule> dutyList = new ArrayList<DutySchedule>();
            for (String duty : curGroup.getDutySchedules()) {
                dutyList.add(new DutySchedule(duty));
            }
            m_dutySchedules.put(key, dutyList);
        }
    }

    public boolean isGroupOnDuty(String group, Calendar time) throws IOException {
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return true;
        }
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (DutySchedule curSchedule : dutySchedules) {
            if (!curSchedule.isInSchedule(time)) continue;
            return true;
        }
        return false;
    }

    public long groupNextOnDuty(String group, Calendar time) throws IOException {
        long next = -1L;
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return 0L;
        }
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (int i = 0; i < dutySchedules.size(); ++i) {
            DutySchedule curSchedule = dutySchedules.get(i);
            long tempnext = curSchedule.nextInSchedule(time);
            if (tempnext >= next && next != -1L) continue;
            LOG.debug("isGroupOnDuty: On duty in {} millisec from schedule {}", (Object)i, (Object)tempnext);
            next = tempnext;
        }
        return next;
    }

    protected abstract void saveXml(String var1) throws IOException;

    public synchronized void saveGroup(String name, Group details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("GroupFactory:saveGroup  null");
        }
        this.m_groups.put(name, details);
        this.saveGroups();
    }

    public void saveRole(Role role) throws Exception {
        this.m_roles.put(role.getName(), role);
        this.saveGroups();
    }

    public synchronized void deleteUser(String name) throws Exception {
        if (name != null && !name.equals("")) {
            for (Group group : this.m_groups.values()) {
                group.removeUser(name);
            }
            for (Role role : this.m_roles.values()) {
                Iterator s = role.getSchedules().iterator();
                while (s.hasNext()) {
                    Schedule sched = (Schedule)s.next();
                    if (!name.equals(sched.getName())) continue;
                    s.remove();
                }
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user name:" + name);
        }
        this.saveGroups();
    }

    public synchronized void deleteGroup(String name) throws Exception {
        if (name != null && !name.equals("")) {
            if (!this.m_groups.containsKey(name)) {
                throw new Exception("GroupFactory:delete Group doesnt exist:" + name);
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user group:" + name);
        }
        this.m_groups.remove(name);
        this.saveGroups();
    }

    public void deleteRole(String name) throws Exception {
        if (name != null && !name.equals("")) {
            if (!this.m_roles.containsKey(name)) {
                throw new Exception("GroupFacotry:deleteRole Role doesn't exist: " + name);
            }
        } else {
            throw new Exception("GroupFactory:deleteRole Invalid role name: " + name);
        }
        this.m_roles.remove(name);
        this.saveGroups();
    }

    public synchronized void renameGroup(String oldName, String newName) throws Exception {
        if (oldName != null && !oldName.equals("")) {
            if (!this.m_groups.containsKey(oldName)) {
                throw new Exception("GroupFactory.renameGroup: Group doesn't exist: " + oldName);
            }
            Group grp = this.m_groups.remove(oldName);
            grp.setName(newName);
            this.m_groups.put(newName, grp);
            this.saveGroups();
        }
    }

    public synchronized void renameUser(String oldName, String newName) throws Exception {
        if (oldName == null || newName == null || oldName == "" || newName == "") {
            throw new Exception("Group Factory: Rename user.. no value ");
        }
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        for (Group group : this.m_groups.values()) {
            ListIterator<String> userList = group.getUsers().listIterator();
            while (userList.hasNext()) {
                String name = (String)userList.next();
                if (!name.equals(oldName)) continue;
                userList.set(newName);
            }
            map.put(group.getName(), group);
        }
        this.m_groups.clear();
        this.m_groups.putAll(map);
        for (Role role : this.m_roles.values()) {
            for (Schedule sched : role.getSchedules()) {
                if (!oldName.equals(sched.getName())) continue;
                sched.setName(newName);
            }
        }
        this.saveGroups();
    }

    public String[] getRoleNames() {
        Set<String> keys = this.m_roles.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Collection<Role> getRoles() {
        return this.m_roles.values();
    }

    public Role getRole(String roleName) {
        return this.m_roles.get(roleName);
    }

    public boolean userHasRole(String userId, String roleid) throws IOException {
        this.update();
        for (Schedule sched : this.getRole(roleid).getSchedules()) {
            if (!userId.equals(sched.getName())) continue;
            return true;
        }
        return false;
    }

    public List<Schedule> getSchedulesForRoleAt(String roleId, Date time) throws IOException {
        this.update();
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Schedule sched : this.getRole(roleId).getSchedules()) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
            schedules.add(sched);
        }
        return schedules;
    }

    public List<Schedule> getUserSchedulesForRole(String userId, String roleId) throws IOException {
        this.update();
        ArrayList<Schedule> scheds = new ArrayList<Schedule>();
        for (Schedule sched : this.getRole(roleId).getSchedules()) {
            if (!userId.equals(sched.getName())) continue;
            scheds.add(sched);
        }
        return scheds;
    }

    public boolean isUserScheduledForRole(String userId, String roleId, Date time) throws IOException {
        this.update();
        for (Schedule sched : this.getUserSchedulesForRole(userId, roleId)) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
            return true;
        }
        Role role = this.getRole(roleId);
        if (userId.equals(role.getSupervisor())) {
            for (Schedule sched : role.getSchedules()) {
                if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OwnedIntervalSequence getRoleScheduleEntries(String roleid, Date start, Date end) throws IOException {
        this.update();
        OwnedIntervalSequence schedEntries = new OwnedIntervalSequence();
        Role role = this.getRole(roleid);
        for (int i = 0; i < role.getSchedules().size(); ++i) {
            int index = i;
            Schedule sched = (Schedule)role.getSchedules().get(index);
            Owner owner = new Owner(roleid, sched.getName(), i);
            schedEntries.addAll((AbstractTimeIntervalSequence)BasicScheduleUtils.getIntervalsCovering(start, end, BasicScheduleUtils.getGroupSchedule(sched), owner));
        }
        OwnedIntervalSequence defaultEntries = new OwnedIntervalSequence(new OwnedInterval(start, end));
        defaultEntries.removeAll((AbstractTimeIntervalSequence)schedEntries);
        Owner supervisor = new Owner(roleid, role.getSupervisor());
        for (OwnedInterval interval : defaultEntries) {
            interval.addOwner(supervisor);
        }
        schedEntries.addAll((AbstractTimeIntervalSequence)defaultEntries);
        return schedEntries;
    }

    public List<Group> findGroupsForUser(String user) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.m_groups.values()) {
            if (!group.getUsers().contains(user)) continue;
            groups.add(group);
        }
        return groups;
    }

    public static class OnmsGroupListMapper {
        public OnmsGroupList map(Collection<OnmsGroup> groups) {
            OnmsGroupList list = new OnmsGroupList();
            list.addAll(groups);
            list.setTotalCount(list.getCount());
            return list;
        }
    }

    public static class OnmsGroupMapper {
        public Group map(OnmsGroup inputGroup) {
            if (inputGroup == null) {
                return null;
            }
            Group xmlGroup = new Group();
            xmlGroup.setName(inputGroup.getName());
            xmlGroup.setComments(inputGroup.getComments());
            xmlGroup.setUsers(inputGroup.getUsers());
            return xmlGroup;
        }

        public OnmsGroup map(Group inputGroup) {
            if (inputGroup == null) {
                return null;
            }
            OnmsGroup xmlGroup = new OnmsGroup(inputGroup.getName());
            xmlGroup.setComments((String)inputGroup.getComments().orElse(null));
            xmlGroup.setUsers(inputGroup.getUsers());
            return xmlGroup;
        }

        public Collection<OnmsGroup> map(Collection<Group> inputGroups) {
            ArrayList<OnmsGroup> xmlGroups = new ArrayList<OnmsGroup>();
            for (Group eachGroup : inputGroups) {
                if (eachGroup == null) continue;
                xmlGroups.add(this.map(eachGroup));
            }
            return xmlGroups;
        }
    }
}

