/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.WsManAssetAdapterConfig;
import org.opennms.netmgt.config.WsManAssetAdapterConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsManAssetAdapterConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WsManAssetAdapterConfigFactory.class);
    private final WsManAssetAdapterConfigManager m_config;

    public WsManAssetAdapterConfigFactory() throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WSMAN_ASSET_ADAPTER_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream reader = new FileInputStream(cfgFile);
        this.m_config = new WsManAssetAdapterConfigManager(cfgFile.lastModified(), reader);
        IOUtils.closeQuietly((InputStream)reader);
    }

    public void reload() throws IOException {
        this.m_config.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String xml) throws IOException {
        this.m_config.getWriteLock().lock();
        try {
            if (xml != null) {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WSMAN_ASSET_ADAPTER_CONFIG_FILE_NAME);
                LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), StandardCharsets.UTF_8);
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
            }
        }
        finally {
            this.m_config.getWriteLock().unlock();
        }
    }

    public WsManAssetAdapterConfig getInstance() {
        return this.m_config;
    }
}

