/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.ActionEvent;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.config.vacuumd.VacuumdConfiguration;
import org.springframework.util.Assert;

public final class VacuumdConfigFactory {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static VacuumdConfigFactory m_singleton = null;
    private static boolean m_loadedFromFile = false;
    private VacuumdConfiguration m_config;

    public VacuumdConfigFactory(InputStream stream) {
        this.m_config = (VacuumdConfiguration)JaxbUtils.unmarshal(VacuumdConfiguration.class, (Reader)new InputStreamReader(stream));
    }

    public VacuumdConfigFactory(VacuumdConfiguration config) {
        this.m_config = config;
        m_loadedFromFile = false;
    }

    public static synchronized void init() throws IOException {
        if (m_singleton != null) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.VACUUMD_CONFIG_FILE_NAME));
            VacuumdConfigFactory.setInstance(new VacuumdConfigFactory(is));
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        m_loadedFromFile = true;
    }

    public static synchronized void reload() throws IOException {
        if (m_loadedFromFile) {
            VacuumdConfigFactory.setInstance(null);
            VacuumdConfigFactory.init();
        }
    }

    public static synchronized VacuumdConfigFactory getInstance() {
        Assert.state((m_singleton != null ? 1 : 0) != 0, (String)"The factory has not been initialized");
        return m_singleton;
    }

    public static synchronized void setInstance(VacuumdConfigFactory instance) {
        m_singleton = instance;
    }

    public synchronized Collection<Automation> getAutomations() {
        return this.m_config.getAutomations();
    }

    public synchronized Collection<Trigger> getTriggers() {
        return this.m_config.getTriggers();
    }

    public synchronized Collection<Action> getActions() {
        return this.m_config.getActions();
    }

    public synchronized Collection<AutoEvent> getAutoEvents() {
        return this.m_config.getAutoEvents();
    }

    public synchronized Collection<ActionEvent> getActionEvents() {
        return this.m_config.getActionEvents();
    }

    public synchronized int getPeriod() {
        return this.m_config.getPeriod();
    }

    public synchronized Trigger getTrigger(String triggerName) {
        for (Trigger trig : this.getTriggers()) {
            if (!trig.getName().equals(triggerName)) continue;
            return trig;
        }
        return null;
    }

    public synchronized Action getAction(String actionName) {
        for (Action act : this.getActions()) {
            if (!act.getName().equals(actionName)) continue;
            return act;
        }
        return null;
    }

    public synchronized Automation getAutomation(String autoName) {
        for (Automation auto : this.getAutomations()) {
            if (!auto.getName().equals(autoName)) continue;
            return auto;
        }
        return null;
    }

    public synchronized AutoEvent getAutoEvent(String name) {
        for (AutoEvent ae : this.getAutoEvents()) {
            if (!ae.getName().equals(name)) continue;
            return ae;
        }
        return null;
    }

    public synchronized String[] getSqlStatements() {
        return this.m_config.getStatements().parallelStream().map(Statement::getContent).collect(Collectors.toList()).toArray(EMPTY_STRING_ARRAY);
    }

    public synchronized List<Statement> getStatements() {
        return this.m_config.getStatements();
    }

    public ActionEvent getActionEvent(String name) {
        for (ActionEvent actionEvent : this.getActionEvents()) {
            if (!actionEvent.getName().equals(name)) continue;
            return actionEvent;
        }
        return null;
    }
}

