/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.netmgt.config.WsManAssetAdapterConfig;
import org.opennms.netmgt.config.wsman.Definition;
import org.opennms.netmgt.config.wsman.WsmanAgentConfig;
import org.opennms.netmgt.config.wsmanAsset.adapter.AssetField;
import org.opennms.netmgt.config.wsmanAsset.adapter.WqlObj;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@EventListener(name="WsManAssetProvisioningAdapter")
public class WsManAssetProvisioningAdapter
extends SimplerQueuedProvisioningAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WsManAssetProvisioningAdapter.class);
    private NodeDao m_nodeDao;
    private EventForwarder m_eventForwarder;
    private WsManAssetAdapterConfig m_config;
    private WSManClientFactory m_factory = new CXFWSManClientFactory();
    private WSManConfigDao m_wsManConfigDao;
    private static final String NAME = "WsManAssetProvisioningAdapter";

    public WsManAssetProvisioningAdapter() {
        super(NAME);
        this.setDelay(30L);
        this.setTimeUnit(TimeUnit.SECONDS);
    }

    @Override
    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        SimpleQueuedProvisioningAdapter.AdapterOperationSchedule aos = new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(this.m_delay, 60L, 3, this.m_timeUnit);
        LOG.info("createScheduleForNode: Scheduling {} for nodeid {} with schedule: {}", new Object[]{adapterOperationType, nodeId, aos});
        return aos;
    }

    @Override
    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doAdd: adding nodeid: {}", (Object)nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Objects.requireNonNull(node, "doAdd: failed to return node for given nodeId: " + nodeId);
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return WsManAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        String vendor = (String)this.m_template.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus arg0) {
                LOG.debug("doAdd: Fetching vendor asset string");
                return node.getAssetRecord().getVendor();
            }
        });
        LOG.debug("doAdd: Fetched asset string: {}", (Object)vendor);
        if (this.m_wsManConfigDao == null) {
            this.m_wsManConfigDao = (WSManConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManConfigDao", WSManConfigDao.class);
        }
        Definition config = this.m_wsManConfigDao.getAgentConfig(ipaddress);
        WSManEndpoint endpoint = WSManConfigDao.getEndpoint((WsmanAgentConfig)config, (InetAddress)ipaddress);
        WSManClient client = this.m_factory.getClient(endpoint);
        LOG.debug("doAdd: m_config: {} ", (Object)this.m_config);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, vendor)) {
                try {
                    String value = WsManAssetProvisioningAdapter.fetchWsManAssetString(client, endpoint, field.getWqlObjs(), field.getFormatString());
                    LOG.debug("doAdd: Setting asset field \" {} \" to value: {}", (Object)field.getName(), (Object)value);
                    BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                }
                catch (BeansException e) {
                    LOG.warn("doAdd: Could not set property \" {} \" on asset object {}", new Object[]{field.getName(), e.getMessage(), e});
                }
                catch (Throwable t) {
                    LOG.warn("doAdd: Could not set value for asset field \" {} \": {}", new Object[]{field.getName(), t.getMessage(), t});
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    private static String fetchWsManAssetString(WSManClient client, WSManEndpoint endpoint, List<WqlObj> wqlObjs, String formatString) {
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> wqls = new ArrayList<String>();
        ArrayList<String> resourceUris = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (WqlObj wqlobj : wqlObjs) {
            LinkedList nodes = Lists.newLinkedList();
            aliases.add(wqlobj.getAlias());
            wqls.add(wqlobj.getWql());
            resourceUris.add(wqlobj.getResourceUri());
            client.enumerateAndPullUsingFilter(wqlobj.getResourceUri(), "http://schemas.microsoft.com/wbem/wsman/1/WQL", wqlobj.getWql(), (List)nodes, true);
            if (!nodes.isEmpty()) {
                values.add(((Node)nodes.get(0)).getTextContent());
                continue;
            }
            values.add(null);
        }
        if (values.size() == aliases.size() && values.size() == resourceUris.size() && values.size() == wqls.size()) {
            Properties substitutions = new Properties();
            boolean foundAValue = false;
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) continue;
                foundAValue = true;
                substitutions.setProperty((String)aliases.get(i), (String)values.get(i));
            }
            if (!foundAValue) {
                LOG.debug("fetchWsManAssetString: Failed to fetch any WsMan values for endpoint {}", (Object)endpoint.getUrl());
                throw new MissingFormatArgumentException("fetchWsManAssetString: Failed to fetch any WsMan values for endpoint " + endpoint.getUrl());
            }
            LOG.debug("fetchWsManAssetString: Fetched asset properties from WsMan agent:\n {}", (Object)WsManAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            if (values.size() != substitutions.size()) {
                LOG.warn("fetchWsManAssetString: Unexpected number of properties returned from WsMan WQL:\n {}", (Object)WsManAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            }
            return PropertiesUtils.substitute((String)formatString, (Properties[])new Properties[]{substitutions});
        }
        LOG.warn("fetchWsManAssetString: Invalid number of parameters returned: {} != {}", (Object)aliases.size(), (Object)values.size());
        throw new MissingFormatArgumentException("fetchWsManAssetString: Invalid number of parameters returned: " + values.size() + " != " + aliases.size());
    }

    protected static String formatPropertiesAsString(Properties props) {
        StringBuilder propertyValues = new StringBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            propertyValues.append("  ");
            propertyValues.append(entry.getKey().toString());
            propertyValues.append(" => ");
            propertyValues.append(entry.getValue().toString());
            propertyValues.append("\n");
        }
        return propertyValues.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doUpdate: updating nodeid: {}", (Object)nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Objects.requireNonNull(node, "doAdd: failed to return node for given nodeId: " + nodeId);
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return WsManAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        String vendor = (String)this.m_template.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus arg0) {
                LOG.debug("doUpdate: Fetching vendor asset string");
                return node.getAssetRecord().getVendor();
            }
        });
        LOG.debug("doUpdate: Fetched asset string: \"{}\"", (Object)vendor);
        if (this.m_wsManConfigDao == null) {
            this.m_wsManConfigDao = (WSManConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManConfigDao", WSManConfigDao.class);
        }
        Definition config = this.m_wsManConfigDao.getAgentConfig(ipaddress);
        WSManEndpoint endpoint = WSManConfigDao.getEndpoint((WsmanAgentConfig)config, (InetAddress)ipaddress);
        WSManClient client = this.m_factory.getClient(endpoint);
        LOG.debug("doUpdate: m_config: \"{}\"", (Object)this.m_config);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, vendor)) {
                try {
                    String value = WsManAssetProvisioningAdapter.fetchWsManAssetString(client, endpoint, field.getWqlObjs(), field.getFormatString());
                    LOG.debug("doUpdate: Setting asset field \" {} \" to value: {}", (Object)field.getName(), (Object)value);
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                    wrapper.setPropertyValue(field.getName(), (Object)value);
                }
                catch (BeansException e) {
                    LOG.warn("doUpdate: Could not set property \" {} \" on asset object {}", new Object[]{field.getName(), e.getMessage(), e});
                }
                catch (Throwable t) {
                    LOG.warn("doUpdate: Could not set value for asset field \" {} \": {}", new Object[]{field.getName(), t.getMessage(), t});
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    public void doNotifyConfigChange(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doNodeConfigChanged: nodeid: {}", (Object)nodeId);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public WsManAssetAdapterConfig getWsManAssetAdapterConfig() {
        return this.m_config;
    }

    public void setWsManAssetAdapterConfig(WsManAssetAdapterConfig mConfig) {
        this.m_config = mConfig;
    }

    private static String nodeToString(Node node) {
        NodeList children = node.getChildNodes();
        Node child = children.item(0);
        return child.getTextContent();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private InetAddress getIpForNode(OnmsNode node) {
        LOG.debug("getIpForNode: node: {} Foreign Source: {}", (Object)node.getNodeId(), (Object)node.getForeignSource());
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        InetAddress ipaddr = InetAddressUtils.getLocalHostAddress();
        if (primaryInterface == null) {
            LOG.debug("getIpForNode: found null SNMP Primary Interface, getting interfaces");
            Set ipInterfaces = node.getIpInterfaces();
            for (OnmsIpInterface onmsIpInterface : ipInterfaces) {
                LOG.debug("getIpForNode: trying Interface with id: {}", (Object)onmsIpInterface.getId());
                if (InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress()) != null) {
                    ipaddr = onmsIpInterface.getIpAddress();
                    continue;
                }
                LOG.debug("getIpForNode: found null ip address on Interface with id: {}", (Object)onmsIpInterface.getId());
            }
        } else {
            LOG.debug("getIpForNode: found SNMP Primary Interface");
            if (InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress()) != null) {
                ipaddr = primaryInterface.getIpAddress();
            } else {
                LOG.debug("getIpForNode: found null ip address on Primary Interface");
            }
        }
        return ipaddr;
    }

    private void handleConfigurationChanged() {
        try {
            this.m_config.update();
        }
        catch (Throwable e) {
            LOG.info("Unable to reload WS-Man asset adapter configuration", e);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(Event e) {
        DaemonTools.handleReloadEvent((Event)e, (String)NAME, event -> this.handleConfigurationChanged());
    }
}

