/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.wmi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;

public enum WmiMgrOperation {
    EQ(0),
    NEQ(1),
    GT(2),
    LT(3);

    private int m_OperationType;

    private WmiMgrOperation(int opType) {
        this.m_OperationType = opType;
    }

    public int getOpNumber() {
        return this.m_OperationType;
    }

    public boolean compareString(Object comp1, String comp2) throws WmiException {
        if (comp1 instanceof String) {
            try {
                SimpleDateFormat fmt2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                Date date1 = WmiClient.convertWmiDate((String)comp1);
                Date date2 = fmt2.parse(comp2);
                return this.compareToDate(date1, date2);
            }
            catch (ParseException fmt2) {
                return this.compareToString((String)comp1, comp2);
            }
        }
        if (comp1 instanceof Integer) {
            Integer compInt1 = (Integer)comp1;
            Integer compInt2 = Integer.parseInt(comp2);
            return this.compareToInteger(compInt1, compInt2);
        }
        if (comp1 instanceof Boolean) {
            Boolean bool1 = (Boolean)comp1;
            Boolean bool2 = Boolean.parseBoolean(comp2);
            return this.compareToBoolean(bool1, bool2);
        }
        if (comp1 instanceof Float) {
            Float fl1 = (Float)comp1;
            Float fl2 = Float.valueOf(Float.parseFloat(comp2));
            return this.compareToFloat(fl1, fl2);
        }
        if (comp1 instanceof Date) {
            Date date2;
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date1 = (Date)comp1;
            try {
                date2 = fmt.parse(comp2);
            }
            catch (ParseException e) {
                throw new WmiException("Parsing date '" + comp2 + "' failed: " + e.getMessage(), e);
            }
            return this.compareToDate(date1, date2);
        }
        return false;
    }

    private boolean compareToString(String comp1, String comp2) {
        switch (this) {
            case EQ: {
                return comp2.equals(comp1);
            }
            case NEQ: {
                return !comp2.equals(comp1);
            }
            case GT: {
                return comp2.length() < comp1.length();
            }
            case LT: {
                return comp2.length() > comp1.length();
            }
        }
        return false;
    }

    private boolean compareToInteger(Integer comp1, Integer comp2) {
        switch (this) {
            case EQ: {
                return comp2.compareTo(comp1) == 0;
            }
            case NEQ: {
                return comp2.compareTo(comp1) != 0;
            }
            case GT: {
                return comp2.compareTo(comp1) < 0;
            }
            case LT: {
                return comp2.compareTo(comp1) > 0;
            }
        }
        return false;
    }

    private boolean compareToBoolean(Boolean bool1, Boolean bool2) {
        switch (this) {
            case EQ: {
                return bool1.equals(bool2);
            }
            case NEQ: 
            case GT: 
            case LT: {
                return !bool1.equals(bool2);
            }
        }
        return false;
    }

    private boolean compareToFloat(Float comp1, Float comp2) {
        switch (this) {
            case EQ: {
                return comp2.compareTo(comp1) == 0;
            }
            case NEQ: {
                return comp2.compareTo(comp1) != 0;
            }
            case GT: {
                return comp2.compareTo(comp1) < 0;
            }
            case LT: {
                return comp2.compareTo(comp1) > 0;
            }
        }
        return false;
    }

    private boolean compareToDate(Date date1, Date date2) {
        switch (this) {
            case EQ: {
                if (date1.equals(date2)) {
                    return true;
                }
            }
            case NEQ: {
                if (!date1.equals(date2)) {
                    return true;
                }
            }
            case GT: {
                if (date1.after(date2)) {
                    return true;
                }
            }
            case LT: {
                if (!date1.before(date2)) break;
                return true;
            }
        }
        return false;
    }
}

