/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.wmi;

import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;

public class WmiCollectionAttribute
extends AbstractCollectionAttribute {
    private final Object m_value;

    public WmiCollectionAttribute(WmiCollectionResource resource, CollectionAttributeType attribType, Object value) {
        super(attribType, (CollectionResource)resource);
        this.m_value = value;
    }

    public Number getNumericValue() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof Number) {
            return (Number)this.m_value;
        }
        try {
            return Double.parseDouble(this.m_value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.m_value == null) {
            return null;
        }
        return this.m_value.toString();
    }

    public String toString() {
        return "WmiCollectionAttribute " + this.getName() + "=" + this.m_value;
    }

    public String getMetricIdentifier() {
        return "Not supported yet._WMI_" + this.getName();
    }
}

