/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wmi;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.support.AgentBasedSyncAbstractDetector;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiDetector
extends AgentBasedSyncAbstractDetector<WmiAgentConfig> {
    public static final Logger LOG = LoggerFactory.getLogger(WmiDetector.class);
    private static final String PROTOCOL_NAME = "WMI";
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_WQL = "NOTSET";
    private static final String DEFAULT_WMI_NAMESPACE = "root/cimv2";
    private String m_matchType;
    private String m_compVal;
    private String m_compOp;
    private String m_wmiClass;
    private String m_wmiObject;
    private String m_wmiWqlStr;
    private String m_username;
    private String m_password;
    private String m_domain;
    private String m_namespace;

    public WmiDetector() {
        super(PROTOCOL_NAME, 0);
    }

    protected void onInit() {
        this.setMatchType(this.getMatchType() != null ? this.getMatchType() : DEFAULT_WMI_MATCH_TYPE);
        this.setCompVal(this.getCompVal() != null ? this.getCompVal() : DEFAULT_WMI_COMP_VAL);
        this.setCompOp(this.getCompOp() != null ? this.getCompOp() : DEFAULT_WMI_COMP_OP);
        this.setWmiClass(this.getWmiClass() != null ? this.getWmiClass() : DEFAULT_WMI_CLASS);
        this.setWmiObject(this.getWmiObject() != null ? this.getWmiObject() : DEFAULT_WMI_OBJECT);
        this.setWmiWqlStr(this.getWmiWqlStr() != null ? this.getWmiWqlStr() : DEFAULT_WMI_WQL);
        this.setNamespace(this.getNamespace() != null ? this.getNamespace() : DEFAULT_WMI_NAMESPACE);
    }

    public WmiAgentConfig getAgentConfig(DetectRequest request) {
        if (request.getRuntimeAttributes() != null) {
            return WmiAgentConfig.fromMap((Map)request.getRuntimeAttributes());
        }
        return new WmiAgentConfig();
    }

    public boolean isServiceDetected(InetAddress address, WmiAgentConfig agentConfig) {
        WmiResult result;
        WmiParams clientParams = null;
        clientParams = this.getWmiWqlStr().equals(DEFAULT_WMI_WQL) ? new WmiParams("InstanceOf", this.getCompVal(), this.getCompOp(), this.getWmiClass(), this.getWmiObject()) : new WmiParams("Wql", this.getCompVal(), this.getCompOp(), this.getWmiWqlStr(), this.getWmiObject());
        if (this.getUsername() != null) {
            agentConfig.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            agentConfig.setPassword(this.getPassword());
        }
        if (this.getDomain() != null) {
            agentConfig.setDomain(this.getDomain());
        }
        if (this.getRetries() > 0) {
            agentConfig.setRetries(this.getRetries());
        }
        if (this.getTimeout() > 0) {
            agentConfig.setTimeout(this.getTimeout());
        }
        return (result = this.isServer(address, agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), this.getNamespace(), this.getMatchType(), agentConfig.getRetries(), agentConfig.getTimeout(), clientParams)) != null && result.getResultCode() != 1 && result.getResultCode() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WmiResult isServer(InetAddress host, String user, String pass, String domain, String namespace, String matchType, int retries, int timeout, WmiParams params) {
        boolean isAServer = false;
        WmiResult result = null;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            WmiManager mgr = null;
            try {
                mgr = new WmiManager(InetAddressUtils.str((InetAddress)host), user, pass, domain, matchType);
                mgr.setNamespace(namespace);
                mgr.init();
                result = mgr.performOp(params);
                if (params.getWmiOperation().equals("Wql")) {
                    LOG.debug("WmiPlugin: {} : {}", (Object)params.getWql(), (Object)WmiResult.convertStateToString(result.getResultCode()));
                } else {
                    LOG.debug("WmiPlugin: \\\\{}\\{} : {}", new Object[]{params.getWmiClass(), params.getWmiObject(), WmiResult.convertStateToString(result.getResultCode())});
                }
                isAServer = true;
                continue;
            }
            catch (WmiException e) {
                StringBuffer message = new StringBuffer();
                message.append("WmiPlugin: Check failed... : ");
                message.append(e.getMessage());
                message.append(" : ");
                message.append(e.getCause() == null ? "" : e.getCause().getMessage());
                LOG.info(message.toString());
                isAServer = false;
                continue;
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        LOG.warn("an error occurred closing the WMI Manager", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public void dispose() {
    }

    public void setMatchType(String matchType) {
        this.m_matchType = matchType;
    }

    public String getMatchType() {
        return this.m_matchType;
    }

    public void setCompVal(String compVal) {
        this.m_compVal = compVal;
    }

    public String getCompVal() {
        return this.m_compVal;
    }

    public void setCompOp(String compOp) {
        this.m_compOp = compOp;
    }

    public String getCompOp() {
        return this.m_compOp;
    }

    public void setWmiClass(String wmiClass) {
        this.m_wmiClass = wmiClass;
    }

    public String getWmiClass() {
        return this.m_wmiClass;
    }

    public void setWmiObject(String wmiObject) {
        this.m_wmiObject = wmiObject;
    }

    public String getWmiObject() {
        return this.m_wmiObject;
    }

    public void setWmiWqlStr(String wmiWqlStr) {
        this.m_wmiWqlStr = wmiWqlStr;
    }

    public String getWmiWqlStr() {
        return this.m_wmiWqlStr;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    public String getNamespace() {
        return this.m_namespace;
    }
}

