/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONObject;
import org.opennms.netmgt.notifd.browser.BrowserNotificationDispatcher;
import org.opennms.netmgt.notifd.browser.BrowserNotificationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationStreamServlet
extends WebSocketServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationStreamServlet.class);

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((request, response) -> {
            String user = request.getHttpServletRequest().getRemoteUser();
            return new NotificationStreamSocket(user);
        });
    }

    public class NotificationStreamSocket
    extends WebSocketAdapter {
        private final String user;
        private BrowserNotificationDispatcher.Handler handler;

        public NotificationStreamSocket(String user) {
            this.user = Objects.requireNonNull(user);
        }

        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            this.handler = BrowserNotificationDispatcher.getInstance().subscribe(this.user, this::sendNotification);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            BrowserNotificationDispatcher.getInstance().unsubscribe(this.handler);
        }

        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            BrowserNotificationDispatcher.getInstance().unsubscribe(this.handler);
        }

        private void sendNotification(BrowserNotificationMessage message) {
            JSONObject json = new JSONObject();
            json.append("id", (Object)message.getId());
            json.append("head", (Object)message.getHead());
            json.append("body", (Object)message.getBody());
            try {
                this.getRemote().sendString(json.toString());
            }
            catch (IOException e) {
                LOG.error("Failed to send out notification", (Throwable)e);
            }
        }
    }
}

