/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.security;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class JSessionIdNoCacheFilter
implements Filter {
    private static final String PARAM_SESSION_ID_NAME = "sessionIdName";
    private static final String DEFAULT_SESSION_ID_NAME = "JSESSIONID";
    private String sessionIdName = "JSESSIONID";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(request, response);
        if (response instanceof HttpServletResponse) {
            this.addHeaderIfRequired((HttpServletResponse)response);
        }
    }

    private void addHeaderIfRequired(HttpServletResponse response) {
        String location;
        boolean cacheControlHeaderNeeded = false;
        Collection cookies = response.getHeaders("Set-Cookie");
        for (String cookie : cookies) {
            if (!cookie.contains(this.sessionIdName)) continue;
            cacheControlHeaderNeeded = true;
            break;
        }
        if ((location = response.getHeader("Location")) != null && location.contains(this.sessionIdName.toLowerCase())) {
            cacheControlHeaderNeeded = true;
        }
        if (cacheControlHeaderNeeded) {
            response.addHeader("Cache-Control", "no-cache");
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        String value = filterConfig.getInitParameter(PARAM_SESSION_ID_NAME);
        if (!Strings.isNullOrEmpty((String)value)) {
            this.sessionIdName = value;
        }
    }
}

