/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

public abstract class NoSubstringFilter
extends OneArgFilter<String> {
    public NoSubstringFilter(String filterType, String fieldName, String daoPropertyName, String value) {
        super(filterType, SQLType.STRING, fieldName, daoPropertyName, value);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " NOT ILIKE %s ";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.not((Criterion)Restrictions.ilike((String)this.getPropertyName(), (String)((String)this.getValue()), (MatchMode)MatchMode.ANYWHERE));
    }

    @Override
    public String getBoundValue(String value) {
        return '%' + value + '%';
    }

    @Override
    public String formatValue(String value) {
        return super.formatValue('%' + value + '%');
    }
}

