/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.group;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.web.group.WebGroup;
import org.opennms.web.group.WebGroupRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GroupController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(GroupController.class);
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private UserManager m_userManager;
    @Autowired
    private WebGroupRepository m_groupRepository;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        if (!StringUtils.hasText((String)operation) && StringUtils.hasText((String)request.getParameter("groupName"))) {
            operation = "show";
        }
        LOG.debug("!!!! Calling operation {} in GroupController", (Object)operation);
        if ("create".equalsIgnoreCase(operation)) {
            return this.createGroup(request, response);
        }
        if ("addGroup".equalsIgnoreCase(operation)) {
            return this.addGroup(request, response);
        }
        if ("show".equalsIgnoreCase(operation)) {
            return this.showGroup(request, response);
        }
        if ("delete".equalsIgnoreCase(operation)) {
            return this.deleteGroup(request, response);
        }
        if ("edit".equalsIgnoreCase(operation)) {
            return this.editGroup(request, response);
        }
        if ("rename".equalsIgnoreCase(operation)) {
            return this.renameGroup(request, response);
        }
        if ("addDutySchedules".equalsIgnoreCase(operation)) {
            return this.addDutySchedules(request, response);
        }
        if ("removeDutySchedules".equalsIgnoreCase(operation)) {
            return this.removeDutySchedules(request, response);
        }
        if ("save".equalsIgnoreCase(operation)) {
            return this.saveGroup(request, response);
        }
        if ("cancel".equalsIgnoreCase(operation)) {
            return this.cancel(request, response);
        }
        return this.listGroups(request, response);
    }

    private ModelAndView listGroups(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("redirect:/admin/userGroupView/groups/list.htm");
    }

    private ModelAndView showGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groupName = request.getParameter("groupName");
        if (!StringUtils.hasText((String)groupName)) {
            throw new ServletException("The groupName parameter is required");
        }
        WebGroup group = this.m_groupRepository.getGroup(groupName);
        return new ModelAndView("/admin/userGroupView/groups/groupDetail", "group", (Object)group);
    }

    private ModelAndView deleteGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groupName = request.getParameter("groupName");
        if (StringUtils.hasText((String)groupName)) {
            this.m_groupRepository.deleteGroup(groupName);
        }
        return this.listGroups(request, response);
    }

    private ModelAndView renameGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oldName = request.getParameter("groupName");
        String newName = request.getParameter("newName");
        if (StringUtils.hasText((String)oldName) && StringUtils.hasText((String)newName)) {
            this.m_groupRepository.renameGroup(oldName, newName);
        }
        return this.listGroups(request, response);
    }

    private ModelAndView addDutySchedules(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession userSession = request.getSession(true);
        if (userSession != null) {
            WebGroup group = (WebGroup)userSession.getAttribute("group.modifyGroup.jsp");
            this.updateGroup(request, group);
            Vector<Object> newSchedule = new Vector<Object>();
            int dutyAddCount = WebSecurityUtils.safeParseInt((String)request.getParameter("numSchedules"));
            for (int j = 0; j < dutyAddCount; ++j) {
                for (int i = 0; i < 7; ++i) {
                    newSchedule.addElement(Boolean.FALSE);
                }
                newSchedule.addElement("0");
                newSchedule.addElement("0");
                group.addDutySchedule(new DutySchedule(newSchedule).toString());
            }
            userSession.setAttribute("group.modifyGroup.jsp", (Object)group);
        }
        return new ModelAndView("admin/userGroupView/groups/modifyGroup");
    }

    private ModelAndView removeDutySchedules(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession userSession = request.getSession(true);
        if (userSession != null) {
            WebGroup newGroup = (WebGroup)userSession.getAttribute("group.modifyGroup.jsp");
            this.updateGroup(request, newGroup);
            userSession.setAttribute("group.modifyGroup.jsp", (Object)newGroup);
        }
        return new ModelAndView("admin/userGroupView/groups/modifyGroup");
    }

    private ModelAndView editGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groupName = request.getParameter("groupName");
        WebGroup group = this.m_groupRepository.getGroup(groupName);
        return this.editGroup(request, group);
    }

    private ModelAndView editGroup(HttpServletRequest request, WebGroup group) throws IOException {
        HttpSession userSession = request.getSession(true);
        userSession.setAttribute("group.modifyGroup.jsp", (Object)group);
        userSession.setAttribute("allCategories.modifyGroup.jsp", (Object)this.m_categoryDao.getAllCategoryNames().toArray(new String[0]));
        userSession.setAttribute("allUsers.modifyGroup.jsp", (Object)this.m_userManager.getUserNames().toArray(new String[0]));
        return new ModelAndView("admin/userGroupView/groups/modifyGroup");
    }

    private ModelAndView saveGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session != null) {
            WebGroup newGroup = (WebGroup)session.getAttribute("group.modifyGroup.jsp");
            this.updateGroup(request, newGroup);
            this.m_groupRepository.saveGroup(newGroup);
        }
        return this.cancel(request, response);
    }

    private ModelAndView cancel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("group.modifyGroup.jsp");
            session.removeAttribute("allCategories.modifyGroup.jsp");
            session.removeAttribute("allUsers.modifyGroup.jsp");
        }
        return this.listGroups(request, response);
    }

    private void updateGroup(HttpServletRequest request, WebGroup newGroup) {
        String[] users = request.getParameterValues("selectedUsers");
        List<Object> userList = users == null ? Collections.emptyList() : Arrays.asList(users);
        newGroup.setUsers(new ArrayList<String>(userList));
        String[] selectedCategories = request.getParameterValues("selectedCategories");
        List<Object> categoryList = selectedCategories == null ? Collections.emptyList() : Arrays.asList(selectedCategories);
        newGroup.setAuthorizedCategories(new ArrayList<String>(categoryList));
        Vector<Object> newSchedule = new Vector<Object>();
        ChoiceFormat days = new ChoiceFormat("0#Mo|1#Tu|2#We|3#Th|4#Fr|5#Sa|6#Su");
        List<String> dutySchedules = newGroup.getDutySchedules();
        dutySchedules.clear();
        int dutyCount = WebSecurityUtils.safeParseInt((String)request.getParameter("dutySchedules"));
        for (int duties = 0; duties < dutyCount; ++duties) {
            newSchedule.clear();
            String deleteFlag = request.getParameter("deleteDuty" + duties);
            if (deleteFlag != null) continue;
            for (int i = 0; i < 7; ++i) {
                String curDayFlag = request.getParameter("duty" + duties + days.format(i));
                if (curDayFlag != null) {
                    newSchedule.addElement(Boolean.TRUE);
                    continue;
                }
                newSchedule.addElement(Boolean.FALSE);
            }
            newSchedule.addElement(request.getParameter("duty" + duties + "Begin"));
            newSchedule.addElement(request.getParameter("duty" + duties + "End"));
            DutySchedule newDuty = new DutySchedule(newSchedule);
            dutySchedules.add(newDuty.toString());
        }
    }

    private ModelAndView createGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("admin/userGroupView/groups/newGroup");
    }

    private ModelAndView addGroup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groupName = request.getParameter("groupName");
        String groupComment = request.getParameter("groupComment");
        if (groupComment == null) {
            groupComment = "";
        }
        boolean hasGroup = false;
        try {
            hasGroup = this.m_groupRepository.groupExists(groupName);
        }
        catch (Throwable e) {
            throw new ServletException("Can't determine if group " + groupName + " already exists in groups.xml.", e);
        }
        if (hasGroup) {
            return new ModelAndView("admin/userGroupView/groups/newGroup", "action", (Object)"redo");
        }
        WebGroup newGroup = new WebGroup();
        newGroup.setName(groupName);
        newGroup.setComments(groupComment);
        return this.editGroup(request, newGroup);
    }
}

