/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.roles;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.Time;
import org.opennms.netmgt.config.WebCalendar;
import org.opennms.netmgt.config.WebGroupManager;
import org.opennms.netmgt.config.WebRole;
import org.opennms.netmgt.config.WebRoleContext;
import org.opennms.netmgt.config.WebRoleManager;
import org.opennms.netmgt.config.WebSchedEntry;
import org.opennms.netmgt.config.WebUserManager;
import org.opennms.netmgt.config.groups.Schedule;

public class AdminRoleServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 7805283401513004127L;
    private static final String LIST = "/admin/userGroupView/roles/list.jsp";
    private static final String VIEW = "/admin/userGroupView/roles/view.jsp";
    private static final String EDIT_DETAILS = "/admin/userGroupView/roles/editDetails.jsp";
    private static final String ADD_ENTRY = "/admin/userGroupView/roles/editSpecific.jsp";
    private static final String EDIT_WEEKLY = "/admin/userGroupView/roles/editWeekly.jsp";
    private static final String EDIT_MONTHLY = "/admin/userGroupView/roles/editMonthly.jsp";
    private static final String EDIT_SPECIFIC = "/admin/userGroupView/roles/editSpecific.jsp";

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reqUrl = request.getServletPath();
        request.setAttribute("reqUrl", (Object)reqUrl);
        Action action = this.getAction(request, response);
        String display = action.execute(request, response);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(display);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private Action getAction(HttpServletRequest request, HttpServletResponse response) {
        String op = request.getParameter("operation");
        if ("delete".equals(op)) {
            return new DeleteAction();
        }
        if ("view".equals(op)) {
            return new ViewAction();
        }
        if ("new".equals(op)) {
            return new NewAction();
        }
        if ("editDetails".equals(op)) {
            return new EditDetailsAction();
        }
        if ("saveDetails".equals(op)) {
            return new SaveDetailsAction();
        }
        if ("addEntry".equals(op)) {
            return new AddEntryAction();
        }
        if ("editEntry".equals(op)) {
            return new EditEntryAction();
        }
        if ("saveEntry".equals(op)) {
            return new SaveEntryAction();
        }
        return new ListAction();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    public void init() throws ServletException {
        super.init();
        try {
            WebRoleContext.init();
            this.getServletContext().setAttribute("roleManager", (Object)WebRoleContext.getWebRoleManager());
            this.getServletContext().setAttribute("userManager", (Object)WebRoleContext.getWebUserManager());
            this.getServletContext().setAttribute("groupManager", (Object)WebRoleContext.getWebGroupManager());
        }
        catch (Throwable e) {
            throw new ServletException("Error initializing RolesServlet", e);
        }
    }

    private WebRoleManager getRoleManager() {
        return WebRoleContext.getWebRoleManager();
    }

    private WebUserManager getUserManager() {
        return WebRoleContext.getWebUserManager();
    }

    private WebGroupManager getGroupManager() {
        return WebRoleContext.getWebGroupManager();
    }

    private class SaveDetailsAction
    implements Action {
        private SaveDetailsAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            if (request.getParameter("save") != null) {
                String roleName = request.getParameter("role");
                WebRole role = AdminRoleServlet.this.getRoleManager().getRole(roleName);
                if (role == null) {
                    role = AdminRoleServlet.this.getRoleManager().createRole();
                }
                role.setName(request.getParameter("roleName"));
                role.setDefaultUser(AdminRoleServlet.this.getUserManager().getUser(request.getParameter("roleUser")));
                role.setMembershipGroup(AdminRoleServlet.this.getGroupManager().getGroup(request.getParameter("roleGroup")));
                role.setDescription(request.getParameter("roleDescr"));
                AdminRoleServlet.this.getRoleManager().saveRole(role);
                request.setAttribute("role", (Object)AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("roleName")));
                return new ViewAction().execute(request, response);
            }
            return new ListAction().execute(request, response);
        }
    }

    private class NewAction
    implements Action {
        private NewAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            WebRole role = AdminRoleServlet.this.getRoleManager().createRole();
            role.setName("NewRole");
            request.setAttribute("role", (Object)role);
            return AdminRoleServlet.EDIT_DETAILS;
        }
    }

    private class EditDetailsAction
    implements Action {
        private EditDetailsAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            WebRole role = AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
            request.setAttribute("role", (Object)role);
            return AdminRoleServlet.EDIT_DETAILS;
        }
    }

    private class SaveEntryAction
    implements Action {
        private SaveEntryAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            try {
                WebRole role = AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
                request.setAttribute("role", (Object)role);
                if (request.getParameter("save") != null) {
                    Date endDate;
                    int schedIndex = this.getIntParameter("schedIndex", request);
                    int timeIndex = this.getIntParameter("timeIndex", request);
                    Date startDate = this.getDateParameters("start", request);
                    if (startDate.equals(endDate = this.getDateParameters("end", request))) {
                        request.setAttribute("error", (Object)"The start time and the end time must not be the same!");
                        request.setAttribute("scheduledUser", (Object)request.getParameter("roleUser"));
                        request.setAttribute("start", (Object)startDate);
                        request.setAttribute("end", (Object)endDate);
                        request.setAttribute("schedIndex", (Object)request.getParameter("schedIndex"));
                        request.setAttribute("timeIndex", (Object)request.getParameter("timeIndex"));
                        return "/admin/userGroupView/roles/editSpecific.jsp";
                    }
                    if (startDate.after(endDate)) {
                        request.setAttribute("error", (Object)"The start time must not be later than the end time!");
                        request.setAttribute("scheduledUser", (Object)request.getParameter("roleUser"));
                        request.setAttribute("start", (Object)startDate);
                        request.setAttribute("end", (Object)endDate);
                        request.setAttribute("schedIndex", (Object)request.getParameter("schedIndex"));
                        request.setAttribute("timeIndex", (Object)request.getParameter("timeIndex"));
                        return "/admin/userGroupView/roles/editSpecific.jsp";
                    }
                    String user = request.getParameter("roleUser");
                    WebSchedEntry entry = new WebSchedEntry(schedIndex, timeIndex, user, startDate, endDate);
                    role.addEntry(entry);
                    AdminRoleServlet.this.getRoleManager().saveRole(role);
                }
                return new ViewAction().execute(request, response);
            }
            catch (ParseException e) {
                throw new ServletException("Unable to parse date: " + e.getMessage(), (Throwable)e);
            }
        }

        private Date getDateParameters(String prefix, HttpServletRequest request) throws ParseException {
            StringBuilder buf = new StringBuilder();
            buf.append(request.getParameter(prefix + "Month"));
            buf.append('-');
            buf.append(request.getParameter(prefix + "Date"));
            buf.append('-');
            buf.append(request.getParameter(prefix + "Year"));
            buf.append(' ');
            buf.append(request.getParameter(prefix + "Hour"));
            buf.append(':');
            buf.append(request.getParameter(prefix + "Minute"));
            buf.append(' ');
            buf.append(request.getParameter(prefix + "AmOrPm"));
            return new SimpleDateFormat("M-d-yyyy h:m a").parse(buf.toString());
        }

        public int getIntParameter(String name, HttpServletRequest request) {
            return WebSecurityUtils.safeParseInt((String)request.getParameter(name));
        }
    }

    private class EditEntryAction
    implements Action {
        private EditEntryAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            WebRole role = AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
            request.setAttribute("role", (Object)role);
            int schedIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("schedIndex"));
            request.setAttribute("schedIndex", (Object)request.getParameter("schedIndex"));
            int timeIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("timeIndex"));
            request.setAttribute("timeIndex", (Object)request.getParameter("timeIndex"));
            Schedule schedule = role.getSchedule(schedIndex);
            request.setAttribute("schedule", (Object)schedule);
            org.opennms.netmgt.config.groups.Time time = role.getTime(schedIndex, timeIndex);
            request.setAttribute("time", (Object)time);
            request.setAttribute("scheduledUser", (Object)schedule.getName());
            Time basicTime = new Time((String)time.getId().orElse(null), (String)time.getDay().orElse(null), time.getBegins(), time.getEnds());
            if (BasicScheduleUtils.isWeekly((Time)basicTime)) {
                return AdminRoleServlet.EDIT_WEEKLY;
            }
            if (BasicScheduleUtils.isMonthly((Time)basicTime)) {
                return AdminRoleServlet.EDIT_MONTHLY;
            }
            request.setAttribute("start", (Object)BasicScheduleUtils.getSpecificTime((String)time.getBegins()));
            request.setAttribute("end", (Object)BasicScheduleUtils.getSpecificTime((String)time.getEnds()));
            return "/admin/userGroupView/roles/editSpecific.jsp";
        }
    }

    private class AddEntryAction
    implements Action {
        private AddEntryAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            try {
                WebRole role = AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
                request.setAttribute("role", (Object)role);
                request.setAttribute("scheduledUser", (Object)role.getDefaultUser().getName());
                Date date = new SimpleDateFormat("MM-dd-yyyy").parse(request.getParameter("date"));
                request.setAttribute("start", (Object)date);
                request.setAttribute("end", (Object)date);
                request.setAttribute("schedIndex", (Object)"-1");
                request.setAttribute("timeIndex", (Object)"-1");
                return "/admin/userGroupView/roles/editSpecific.jsp";
            }
            catch (ParseException e) {
                throw new ServletException("Unable to parse date: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private class ViewAction
    implements Action {
        private ViewAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            try {
                String dateSpec;
                WebRole role = (WebRole)request.getAttribute("role");
                if (role == null) {
                    role = AdminRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
                    request.setAttribute("role", (Object)role);
                }
                Date month = (dateSpec = request.getParameter("month")) == null ? new Date() : new SimpleDateFormat("MM-yyyy").parse(dateSpec);
                WebCalendar calendar = role.getCalendar(month);
                request.setAttribute("calendar", (Object)calendar);
                return AdminRoleServlet.VIEW;
            }
            catch (ParseException e) {
                throw new ServletException("Unable to parse date: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private class DeleteAction
    implements Action {
        private DeleteAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            AdminRoleServlet.this.getRoleManager().deleteRole(request.getParameter("role"));
            ListAction list = new ListAction();
            return list.execute(request, response);
        }
    }

    private static class ListAction
    implements Action {
        private ListAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) {
            return AdminRoleServlet.LIST;
        }
    }

    private static interface Action {
        public String execute(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;
    }
}

