/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.element;

import java.io.Serializable;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/element/service.htm"})
public class ServiceController
implements InitializingBean {
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"ifserviceid"})
    public ModelAndView handleService(@RequestParam(value="ifserviceid") int ifServiceId) {
        OnmsMonitoredService service = (OnmsMonitoredService)this.m_monitoredServiceDao.get((Serializable)Integer.valueOf(ifServiceId));
        if (service == null) {
            return this.createErrorModelAndView(ifServiceId);
        }
        return this.createSuccessModelAndView(service);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"node", "intf", "service"})
    public ModelAndView handleService(@RequestParam(value="node") int node, @RequestParam(value="intf") String intf, @RequestParam(value="service") int serviceId) {
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(node), InetAddressUtils.addr((String)intf), Integer.valueOf(serviceId));
        if (service == null) {
            return this.createErrorModelAndView(node, intf, serviceId);
        }
        return this.createSuccessModelAndView(service);
    }

    private ModelAndView createErrorModelAndView(int ifServiceId) {
        ModelAndView modelAndView = new ModelAndView("element/errorPageOneKeyService");
        modelAndView.addObject("ifServiceId", (Object)ifServiceId);
        return modelAndView;
    }

    private ModelAndView createErrorModelAndView(int node, String intf, int serviceId) {
        ModelAndView modelAndView = new ModelAndView("element/errorPageService");
        modelAndView.addObject("node", (Object)node);
        modelAndView.addObject("intf", (Object)intf);
        modelAndView.addObject("serviceId", (Object)serviceId);
        return modelAndView;
    }

    private ModelAndView createSuccessModelAndView(OnmsMonitoredService service) {
        ModelAndView modelAndView = new ModelAndView("element/service");
        modelAndView.addObject("service", (Object)service);
        return modelAndView;
    }
}

