/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.report.database;

import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.web.svclayer.SchedulerService;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

public class DeliveryOptionsValidator {
    private SchedulerService m_reportSchedulerService;

    public void validateDeliveryOptions(DeliveryOptions deliveryOptions, ValidationContext context) {
        MessageContext messages = context.getMessageContext();
        if (!deliveryOptions.getSendMail().booleanValue() && !deliveryOptions.getPersist().booleanValue()) {
            messages.addMessage(new MessageBuilder().error().source((Object)"sendMail").defaultText("one of send mail or persist should be selected").build());
            messages.addMessage(new MessageBuilder().error().source((Object)"persist").defaultText("one of send mail or persist should be selected").build());
        } else if (deliveryOptions.getSendMail().booleanValue() && deliveryOptions.getMailTo() == "") {
            messages.addMessage(new MessageBuilder().error().source((Object)"mailTo").defaultText("cannot have empty mail recipient").build());
        }
        if (deliveryOptions.getInstanceId().length() == 0) {
            messages.addMessage(new MessageBuilder().error().source((Object)"instanceId").defaultText("cannot have an empty Id for the report instance").build());
        } else if (this.m_reportSchedulerService.exists(deliveryOptions.getInstanceId()).booleanValue()) {
            messages.addMessage(new MessageBuilder().error().source((Object)"instanceId").defaultText("report instanceId is already in use").build());
        }
    }

    public void setReportSchedulerService(SchedulerService reportSchedulerService) {
        this.m_reportSchedulerService = reportSchedulerService;
    }
}

