/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.filter.BaseFilter;
import org.opennms.web.filter.SQLType;

public abstract class OneArgFilter<T>
extends BaseFilter<T> {
    private T m_value;

    public OneArgFilter(String filterType, SQLType<T> sqlType, String fieldName, String propertyName, T value) {
        super(filterType, sqlType, fieldName, propertyName);
        this.m_value = value;
    }

    public final T getValue() {
        return this.m_value;
    }

    public abstract String getSQLTemplate();

    public T getBoundValue(T value) {
        return value;
    }

    @Override
    public final int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        this.bindValue(ps, parameterIndex, this.getBoundValue(this.m_value));
        return 1;
    }

    @Override
    public final String getValueString() {
        return this.getValueAsString(this.m_value);
    }

    @Override
    public final String getParamSql() {
        return String.format(this.getSQLTemplate(), "?");
    }

    @Override
    public final String getSql() {
        return String.format(this.getSQLTemplate(), this.formatValue(this.m_value));
    }

    @Override
    public String getTextDescription() {
        return this.getDescription();
    }
}

