/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.api.Util;
import org.opennms.web.servlet.MissingParameterException;

public class NodeRescanServlet
extends HttpServlet {
    private static final long serialVersionUID = -3183139374532183137L;
    protected EventProxy proxy;

    public void init() throws ServletException {
        try {
            this.proxy = Util.createEventProxy();
        }
        catch (Throwable e) {
            throw new ServletException("Exception", e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String returnUrl = request.getParameter("returnUrl");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "returnUrl"});
        }
        if (returnUrl == null) {
            throw new MissingParameterException("returnUrl", new String[]{"node", "returnUrl"});
        }
        try {
            int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/forceRescan", "NodeRescanServlet");
            bldr.setNodeid((long)nodeId);
            bldr.setHost("host");
            this.proxy.send(bldr.getEvent());
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)returnUrl));
        }
        catch (Throwable e) {
            throw new ServletException("Exception sending node rescan event", e);
        }
    }
}

