/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.inventory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.opennms.report.configuration.svclayer.ConfigurationReportCriteria;
import org.opennms.report.configuration.svclayer.ConfigurationReportService;
import org.opennms.report.inventory.svclayer.InventoryReportCriteria;
import org.opennms.report.inventory.svclayer.InventoryReportService;
import org.opennms.web.controller.inventory.RancidReportExecCommClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/inventory/rancidReportExec.htm"})
public class RancidReportExecController {
    private static final Logger LOG = LoggerFactory.getLogger(RancidReportExecController.class);
    @Autowired
    private ConfigurationReportService m_configurationReportService;
    @Autowired
    private InventoryReportService m_inventoryReportService;

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView onSubmit(HttpServletRequest request, RancidReportExecCommClass bean) {
        ConfigurationReportCriteria criteria;
        LOG.debug("RancidReportExecController ModelAndView onSubmit");
        LOG.debug("RancidReportExecController ModelAndView type {}", (Object)bean.getReporttype());
        LOG.debug("RancidReportExecController ModelAndView type {}", (Object)bean.getFieldhas());
        String user = request.getRemoteUser();
        Date reportRequestDate = new Date();
        ModelAndView mav = new ModelAndView("inventory/rancidReportExec");
        if (bean.getReporttype().compareTo("rancidlist") == 0) {
            LOG.debug("RancidReportExecController rancidlist report");
            criteria = new ConfigurationReportCriteria(bean.getDate(), bean.getReportfiletype(), bean.getReportemail(), user, reportRequestDate);
            boolean done = this.m_configurationReportService.runReport(criteria);
            mav.addObject("type", (Object)"Rancid List");
            if (!done) {
                LOG.debug("RancidReportExecController error");
            }
        } else if (bean.getReporttype().compareTo("inventory") == 0) {
            LOG.debug("RancidReportExecController inventory report");
            criteria = new InventoryReportCriteria(bean.getDate(), bean.getFieldhas(), bean.getReportfiletype(), bean.getReportemail(), user, reportRequestDate);
            boolean done = this.m_inventoryReportService.runReport((InventoryReportCriteria)criteria);
            mav.addObject("type", (Object)"Inventory Report");
            if (!done) {
                LOG.debug("RancidReportExecController error");
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        try {
            mav.addObject("date", (Object)format.parse(bean.getDate()));
        }
        catch (ParseException pe) {
            mav.addObject("date", (Object)format.format(Calendar.getInstance().getTime()));
        }
        mav.addObject("searchfield", (Object)bean.getFieldhas());
        if (bean.getReportfiletype().compareTo("pdftype") == 0) {
            mav.addObject("reportformat", (Object)"PDF");
        } else {
            mav.addObject("reportformat", (Object)"HTML");
        }
        return mav;
    }
}

