/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.svclayer.TroubleTicketProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class AlarmTicketController
extends MultiActionController {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmTicketController.class);
    private TroubleTicketProxy m_troubleTicketProxy;

    public ModelAndView create(HttpServletRequest request, HttpServletResponse response, CommandBean bean) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user", request.getRemoteUser());
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (paramName.equals("alarm") && paramName.equals("redirect")) continue;
            parameters.put(paramName, request.getParameter(paramName));
        }
        this.m_troubleTicketProxy.createTicket(bean.getAlarm(), parameters);
        return new ModelAndView("redirect:" + bean.getRedirect());
    }

    public ModelAndView update(HttpServletRequest request, HttpServletResponse response, CommandBean bean) {
        this.m_troubleTicketProxy.updateTicket(bean.getAlarm());
        return new ModelAndView("redirect:" + bean.getRedirect());
    }

    public ModelAndView close(HttpServletRequest request, HttpServletResponse response, CommandBean bean) {
        this.m_troubleTicketProxy.closeTicket(bean.getAlarm());
        return new ModelAndView("redirect:" + bean.getRedirect());
    }

    public void setTroubleTicketProxy(TroubleTicketProxy troubleTicketProxy) {
        this.m_troubleTicketProxy = troubleTicketProxy;
    }

    static class CommandBean {
        Integer alarm;
        String redirect;

        CommandBean() {
        }

        public Integer getAlarm() {
            return this.alarm;
        }

        public void setAlarm(Integer alarm) {
            this.alarm = alarm;
        }

        public String getRedirect() {
            return this.redirect;
        }

        public void setRedirect(String redirect) {
            this.redirect = redirect;
        }
    }
}

