/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.asset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.asset.Asset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AssetModel {
    private static final Logger LOG = LoggerFactory.getLogger(AssetModel.class);
    private static final String[][] s_columns = new String[][]{{"Address 1", "address1"}, {"Address 2", "address2"}, {"Asset Number", "assetNumber"}, {"Building", "building"}, {"Circuit ID", "circuitId"}, {"City", "city"}, {"Comments", "comment"}, {"Date Installed", "dateInstalled"}, {"Department", "department"}, {"Description", "description"}, {"Display Category", "displayCategory"}, {"Division", "division"}, {"Floor", "floor"}, {"Lease", "lease"}, {"Lease Expires", "leaseExpires"}, {"Maint Contract", "maintContract"}, {"Maint Contract Expires", "maintContractExpires"}, {"Maint Phone", "supportPhone"}, {"Manufacturer", "manufacturer"}, {"Model Number", "modelNumber"}, {"Notification Category", "notifyCategory"}, {"Operating System", "operatingSystem"}, {"Port", "port"}, {"Poller Category", "pollerCategory"}, {"Rack", "rack"}, {"Region", "region"}, {"Room", "room"}, {"Serial Number", "serialNumber"}, {"Slot", "slot"}, {"State", "state"}, {"Threshold Category", "thresholdCategory"}, {"User Last Modified", "userLastModified"}, {"Vendor", "vendor"}, {"Vendor Asset Number", "vendorAssetNumber"}, {"Vendor Fax", "vendorFax"}, {"Vendor Phone", "vendorPhone"}, {"ZIP Code", "zip"}, {"Username", "username"}, {"Password", "password"}, {"Enable Password", "enable"}, {"Connection type", "connection"}, {"Auto Enable", "autoenable"}, {"Cpu", "cpu"}, {"Ram", "ram"}, {"Storage Controller", "storagectrl"}, {"HDD 1", "hdd1"}, {"HDD 2", "hdd2"}, {"HDD 3", "hdd3"}, {"HDD 4", "hdd4"}, {"HDD 5", "hdd5"}, {"HDD 6", "hdd6"}, {"Number of power supplies", "numpowersupplies"}, {"Inputpower", "inputpower"}, {"Additional hardware", "additionalhardware"}, {"Admin", "admin"}, {"SNMP community", "snmpcommunity"}, {"Rack unit height", "rackunitheight"}, {"GeoLocation Longitude", "longitude"}, {"GeoLocation Latitude", "latitude"}, {"Country", "country"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset getAsset(int nodeId) throws SQLException {
        Asset asset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM ASSETS WHERE NODEID=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Asset[] assets = AssetModel.rs2Assets(rs);
            if (assets.length > 0) {
                asset = assets[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return asset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset[] getAllAssets() throws SQLException {
        Asset[] assets = new Asset[]{};
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM ASSETS");
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            assets = AssetModel.rs2Assets(rs);
        }
        finally {
            d.cleanUp();
        }
        return assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAsset(Asset asset) throws SQLException {
        Assert.notNull((Object)asset, (String)"argument asset cannot be null");
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO ASSETS (nodeID,category,manufacturer,vendor,modelNumber,serialNumber,description,circuitId,assetNumber,operatingSystem,rack,slot,port,region,division,department,address1,address2,city,state,zip,building,floor,room,vendorPhone,vendorFax,userLastModified,lastModifiedDate,dateInstalled,lease,leaseExpires,supportPhone,maintContract,vendorAssetNumber,maintContractExpires,displayCategory,notifyCategory,pollerCategory,thresholdCategory,comment,username,password,enable,connection,autoenable,cpu,ram,storagectrl,hdd1,hdd2,hdd3,hdd4,hdd5,hdd6,numpowersupplies,inputpower,additionalhardware,admin,snmpcommunity,rackunitheight,longitude,latitude,country) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            d.watch((Object)stmt);
            stmt.setInt(1, asset.nodeId);
            stmt.setString(2, asset.category);
            stmt.setString(3, asset.manufacturer);
            stmt.setString(4, asset.vendor);
            stmt.setString(5, asset.modelNumber);
            stmt.setString(6, asset.serialNumber);
            stmt.setString(7, asset.description);
            stmt.setString(8, asset.circuitId);
            stmt.setString(9, asset.assetNumber);
            stmt.setString(10, asset.operatingSystem);
            stmt.setString(11, asset.rack);
            stmt.setString(12, asset.slot);
            stmt.setString(13, asset.port);
            stmt.setString(14, asset.region);
            stmt.setString(15, asset.division);
            stmt.setString(16, asset.department);
            stmt.setString(17, asset.address1);
            stmt.setString(18, asset.address2);
            stmt.setString(19, asset.city);
            stmt.setString(20, asset.state);
            stmt.setString(21, asset.zip);
            stmt.setString(22, asset.building);
            stmt.setString(23, asset.floor);
            stmt.setString(24, asset.room);
            stmt.setString(25, asset.vendorPhone);
            stmt.setString(26, asset.vendorFax);
            stmt.setString(27, asset.userLastModified);
            stmt.setTimestamp(28, new Timestamp(asset.lastModifiedDate.getTime()));
            stmt.setString(29, asset.dateInstalled);
            stmt.setString(30, asset.lease);
            stmt.setString(31, asset.leaseExpires);
            stmt.setString(32, asset.supportPhone);
            stmt.setString(33, asset.maintContract);
            stmt.setString(34, asset.vendorAssetNumber);
            stmt.setString(35, asset.maintContractExpires);
            stmt.setString(36, asset.displayCategory);
            stmt.setString(37, asset.notifyCategory);
            stmt.setString(38, asset.pollerCategory);
            stmt.setString(39, asset.thresholdCategory);
            stmt.setString(40, asset.comments);
            stmt.setString(41, asset.username);
            stmt.setString(42, asset.password);
            stmt.setString(43, asset.enable);
            stmt.setString(44, asset.connection);
            stmt.setString(45, asset.autoenable);
            stmt.setString(46, asset.cpu);
            stmt.setString(47, asset.ram);
            stmt.setString(48, asset.storagectrl);
            stmt.setString(49, asset.hdd1);
            stmt.setString(50, asset.hdd2);
            stmt.setString(51, asset.hdd3);
            stmt.setString(52, asset.hdd4);
            stmt.setString(53, asset.hdd5);
            stmt.setString(54, asset.hdd6);
            stmt.setString(55, asset.numpowersupplies);
            stmt.setString(56, asset.inputpower);
            stmt.setString(57, asset.additionalhardware);
            stmt.setString(58, asset.admin);
            stmt.setString(59, asset.snmpcommunity);
            stmt.setString(60, asset.rackunitheight);
            stmt.setFloat(61, this.safeFloat(asset.longitude).floatValue());
            stmt.setFloat(62, this.safeFloat(asset.latitude).floatValue());
            stmt.setString(63, asset.country);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAsset(Asset asset) throws SQLException {
        Assert.notNull((Object)asset, (String)"argument asset cannot be null");
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE ASSETS SET category=?,manufacturer=?,vendor=?,modelNumber=?,serialNumber=?,description=?,circuitId=?,assetNumber=?,operatingSystem=?,rack=?,slot=?,port=?,region=?,division=?,department=?,address1=?,address2=?,city=?,state=?,zip=?,building=?,floor=?,room=?,vendorPhone=?,vendorFax=?,userLastModified=?,lastModifiedDate=?,dateInstalled=?,lease=?,leaseExpires=?,supportPhone=?,maintContract=?,vendorAssetNumber=?,maintContractExpires=?,displayCategory=?,notifyCategory=?,pollerCategory=?,thresholdCategory=?,comment=?, username=?, password=?,enable=?,connection=?,autoenable=?,cpu=?,ram=?,storagectrl=?,hdd1=?,hdd2=?,hdd3=?,hdd4=?,hdd5=?,hdd6=?,numpowersupplies=?,inputpower=?,additionalhardware=?,admin=?,snmpcommunity=?,rackunitheight=?,longitude=?,latitude=?,country=? WHERE nodeid=?");
            d.watch((Object)stmt);
            stmt.setString(1, asset.category);
            stmt.setString(2, asset.manufacturer);
            stmt.setString(3, asset.vendor);
            stmt.setString(4, asset.modelNumber);
            stmt.setString(5, asset.serialNumber);
            stmt.setString(6, asset.description);
            stmt.setString(7, asset.circuitId);
            stmt.setString(8, asset.assetNumber);
            stmt.setString(9, asset.operatingSystem);
            stmt.setString(10, asset.rack);
            stmt.setString(11, asset.slot);
            stmt.setString(12, asset.port);
            stmt.setString(13, asset.region);
            stmt.setString(14, asset.division);
            stmt.setString(15, asset.department);
            stmt.setString(16, asset.address1);
            stmt.setString(17, asset.address2);
            stmt.setString(18, asset.city);
            stmt.setString(19, asset.state);
            stmt.setString(20, asset.zip);
            stmt.setString(21, asset.building);
            stmt.setString(22, asset.floor);
            stmt.setString(23, asset.room);
            stmt.setString(24, asset.vendorPhone);
            stmt.setString(25, asset.vendorFax);
            stmt.setString(26, asset.userLastModified);
            stmt.setTimestamp(27, new Timestamp(asset.lastModifiedDate.getTime()));
            stmt.setString(28, asset.dateInstalled);
            stmt.setString(29, asset.lease);
            stmt.setString(30, asset.leaseExpires);
            stmt.setString(31, asset.supportPhone);
            stmt.setString(32, asset.maintContract);
            stmt.setString(33, asset.vendorAssetNumber);
            stmt.setString(34, asset.maintContractExpires);
            stmt.setString(35, asset.displayCategory);
            stmt.setString(36, asset.notifyCategory);
            stmt.setString(37, asset.pollerCategory);
            stmt.setString(38, asset.thresholdCategory);
            stmt.setString(39, asset.comments);
            stmt.setString(40, asset.username);
            stmt.setString(41, asset.password);
            stmt.setString(42, asset.enable);
            stmt.setString(43, asset.connection);
            stmt.setString(44, asset.autoenable);
            stmt.setString(45, asset.cpu);
            stmt.setString(46, asset.ram);
            stmt.setString(47, asset.storagectrl);
            stmt.setString(48, asset.hdd1);
            stmt.setString(49, asset.hdd2);
            stmt.setString(50, asset.hdd3);
            stmt.setString(51, asset.hdd4);
            stmt.setString(52, asset.hdd5);
            stmt.setString(53, asset.hdd6);
            stmt.setString(54, asset.numpowersupplies);
            stmt.setString(55, asset.inputpower);
            stmt.setString(56, asset.additionalhardware);
            stmt.setString(57, asset.admin);
            stmt.setString(58, asset.snmpcommunity);
            stmt.setString(59, asset.rackunitheight);
            Float longitude = this.safeFloat(asset.longitude);
            if (longitude == null) {
                stmt.setNull(60, 6);
            } else {
                stmt.setFloat(60, longitude.floatValue());
            }
            Float latitude = this.safeFloat(asset.latitude);
            if (latitude == null) {
                stmt.setNull(61, 6);
            } else {
                stmt.setFloat(61, latitude.floatValue());
            }
            stmt.setString(62, asset.country);
            stmt.setInt(63, asset.nodeId);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatchingAsset[] searchAssets(String columnName, String searchText) throws SQLException {
        Assert.notNull((Object)columnName, (String)"argument columnName cannot be null");
        Assert.notNull((Object)searchText, (String)"argument searchText cannot be null");
        ArrayList<MatchingAsset> list = new ArrayList<MatchingAsset>();
        columnName = WebSecurityUtils.sanitizeDbColumnName((String)columnName);
        DBUtils d = new DBUtils(AssetModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT ASSETS.NODEID, NODE.NODELABEL, ASSETS." + columnName + " FROM ASSETS, NODE WHERE LOWER(ASSETS." + columnName + ") LIKE ? AND ASSETS.NODEID=NODE.NODEID ORDER BY NODE.NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, "%" + searchText.toLowerCase() + "%");
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                MatchingAsset asset = new MatchingAsset();
                asset.nodeId = rs.getInt("nodeID");
                asset.nodeLabel = rs.getString("nodelabel");
                asset.matchingValue = rs.getString(columnName);
                asset.columnSearched = columnName;
                list.add(asset);
            }
        }
        finally {
            d.cleanUp();
        }
        return list.toArray(new MatchingAsset[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatchingAsset[] searchNodesWithAssets() throws SQLException {
        ArrayList<MatchingAsset> list = new ArrayList<MatchingAsset>();
        DBUtils d = new DBUtils(AssetModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select nodeid, nodelabel from node where nodeid in (select nodeid from assets where coalesce(manufacturer,'') != '' or coalesce(vendor,'') != '' or coalesce(modelNumber,'') != '' or coalesce(serialNumber,'') != '' or coalesce(description,'') != '' or coalesce(circuitId,'') != '' or coalesce(assetNumber,'') != '' or coalesce(operatingSystem,'') != '' or coalesce(rack,'') != '' or coalesce(slot,'') != '' or coalesce(port,'') != '' or coalesce(region,'') != '' or coalesce(division,'') != '' or coalesce(department,'') != '' or coalesce(address1,'') != '' or coalesce(address2,'') != '' or coalesce(city,'') != '' or coalesce(state,'') != '' or coalesce(zip,'') != '' or coalesce(building,'') != '' or coalesce(floor,'') != '' or coalesce(room,'') != '' or coalesce(vendorPhone,'') != '' or coalesce(vendorFax,'') != '' or coalesce(dateInstalled,'') != '' or coalesce(lease,'') != '' or coalesce(leaseExpires,'') != '' or coalesce(supportPhone,'') != '' or coalesce(maintContract,'') != '' or coalesce(vendorAssetNumber,'') != '' or coalesce(maintContractExpires,'') != '' or coalesce(displayCategory,'') != '' or coalesce(notifyCategory,'') != '' or coalesce(pollerCategory,'') != '' or coalesce(thresholdCategory,'') != '' or coalesce(comment,'') != '' or coalesce(username,'') != '' or coalesce(password,'') != '' or coalesce(enable,'') != '' or coalesce(connection,'') != '' or coalesce(autoenable,'') != '' or coalesce(cpu,'') != '' or coalesce(ram,'') != '' or coalesce(storagectrl,'') != '' or coalesce(hdd1,'') != '' or coalesce(hdd2,'') != '' or coalesce(hdd3,'') != '' or coalesce(hdd4,'') != '' or coalesce(hdd5,'') != '' or coalesce(hdd6,'') != '' or coalesce(numpowersupplies,'') != '' or coalesce(inputpower,'') != '' or coalesce(additionalhardware,'') != '' or coalesce(admin,'') != '' or coalesce(snmpcommunity,'') != '' or coalesce(rackunitheight,'') != '')");
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                MatchingAsset asset = new MatchingAsset();
                asset.nodeId = rs.getInt("nodeID");
                asset.nodeLabel = rs.getString("nodelabel");
                asset.matchingValue = "";
                asset.columnSearched = "";
                list.add(asset);
            }
        }
        finally {
            d.cleanUp();
        }
        return list.toArray(new MatchingAsset[list.size()]);
    }

    protected static Asset[] rs2Assets(ResultSet rs) throws SQLException {
        ArrayList<Asset> list = new ArrayList<Asset>();
        while (rs.next()) {
            Object latitude;
            Asset asset = new Asset();
            asset.nodeId = rs.getInt("nodeID");
            asset.setCategory(rs.getString("category"));
            asset.setManufacturer(rs.getString("manufacturer"));
            asset.setVendor(rs.getString("vendor"));
            asset.setModelNumber(rs.getString("modelNumber"));
            asset.setSerialNumber(rs.getString("serialNumber"));
            asset.setDescription(rs.getString("description"));
            asset.setCircuitId(rs.getString("circuitId"));
            asset.setAssetNumber(rs.getString("assetNumber"));
            asset.setOperatingSystem(rs.getString("operatingSystem"));
            asset.setRack(rs.getString("rack"));
            asset.setSlot(rs.getString("slot"));
            asset.setPort(rs.getString("port"));
            asset.setRegion(rs.getString("region"));
            asset.setDivision(rs.getString("division"));
            asset.setDepartment(rs.getString("department"));
            asset.setAddress1(rs.getString("address1"));
            asset.setAddress2(rs.getString("address2"));
            asset.setCity(rs.getString("city"));
            asset.setState(rs.getString("state"));
            asset.setZip(rs.getString("zip"));
            asset.setBuilding(rs.getString("building"));
            asset.setFloor(rs.getString("floor"));
            asset.setRoom(rs.getString("room"));
            asset.setVendorPhone(rs.getString("vendorPhone"));
            asset.setVendorFax(rs.getString("vendorFax"));
            asset.setUserLastModified(rs.getString("userLastModified"));
            asset.setLease(rs.getString("lease"));
            asset.setSupportPhone(rs.getString("supportPhone"));
            asset.setMaintContract(rs.getString("maintContract"));
            asset.setDateInstalled(rs.getString("dateInstalled"));
            asset.setLeaseExpires(rs.getString("leaseExpires"));
            asset.setMaintContractExpires(rs.getString("maintContractExpires"));
            asset.setVendorAssetNumber(rs.getString("vendorAssetNumber"));
            asset.setDisplayCategory(rs.getString("displayCategory"));
            asset.setNotifyCategory(rs.getString("notifyCategory"));
            asset.setPollerCategory(rs.getString("pollerCategory"));
            asset.setThresholdCategory(rs.getString("thresholdCategory"));
            asset.setComments(rs.getString("comment"));
            asset.setUsername(rs.getString("username"));
            asset.setPassword(rs.getString("password"));
            asset.setEnable(rs.getString("enable"));
            asset.setConnection(rs.getString("connection"));
            asset.setAutoenable(rs.getString("autoenable"));
            asset.setCpu(rs.getString("cpu"));
            asset.setRam(rs.getString("ram"));
            asset.setStoragectrl(rs.getString("storagectrl"));
            asset.setHdd1(rs.getString("hdd1"));
            asset.setHdd2(rs.getString("hdd2"));
            asset.setHdd3(rs.getString("hdd3"));
            asset.setHdd4(rs.getString("hdd4"));
            asset.setHdd5(rs.getString("hdd5"));
            asset.setHdd6(rs.getString("hdd6"));
            asset.setNumpowersupplies(rs.getString("numpowersupplies"));
            asset.setInputpower(rs.getString("inputpower"));
            asset.setAdditionalhardware(rs.getString("additionalhardware"));
            asset.setAdmin(rs.getString("admin"));
            asset.setSnmpcommunity(rs.getString("snmpcommunity"));
            asset.setRackunitheight(rs.getString("rackunitheight"));
            Object longitude = rs.getObject("longitude");
            if (longitude != null) {
                asset.setLongitude(Float.valueOf(rs.getFloat("longitude")).toString());
            }
            if ((latitude = rs.getObject("latitude")) != null) {
                asset.setLatitude(Float.valueOf(rs.getFloat("latitude")).toString());
            }
            asset.setCountry(rs.getString("country"));
            asset.lastModifiedDate = new Date(rs.getTimestamp("lastModifiedDate").getTime());
            list.add(asset);
        }
        return list.toArray(new Asset[list.size()]);
    }

    public static String[][] getColumns() {
        return s_columns;
    }

    private Float safeFloat(String value) {
        if (StringUtils.hasLength((String)value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.trace("Failed to parse float value from {}", (Object)value, (Object)e);
            }
        }
        return null;
    }

    public static class MatchingAsset {
        public int nodeId;
        public String nodeLabel;
        public String matchingValue;
        public String columnSearched;
    }
}

