/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.AdminCategoryService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class NodeCategoryBoxController
extends AbstractController {
    private AdminCategoryService m_adminCategoryService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String nodeIdString = request.getParameter("node");
        if (nodeIdString == null) {
            throw new MissingParameterException("node");
        }
        int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        List categories = this.m_adminCategoryService.findByNode(nodeId);
        ModelAndView modelAndView = new ModelAndView("/includes/nodeCategory-box", "categories", (Object)categories);
        if (request.isUserInRole("ROLE_ADMIN")) {
            modelAndView.addObject("isAdmin", (Object)"true");
        }
        return modelAndView;
    }

    public AdminCategoryService getAdminCategoryService() {
        return this.m_adminCategoryService;
    }

    public void setAdminCategoryService(AdminCategoryService adminCategoryService) {
        this.m_adminCategoryService = adminCategoryService;
    }
}

