/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification.filter;

import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.SortStyle;

public class NotificationCriteria {
    Filter[] m_filters = null;
    SortStyle m_sortStyle = SortStyle.ID;
    AcknowledgeType m_ackType = AcknowledgeType.UNACKNOWLEDGED;
    int m_limit = -1;
    int m_offset = -1;

    public NotificationCriteria(Filter ... filters) {
        this(filters, null, null, -1, -1);
    }

    public NotificationCriteria(Filter[] filters, SortStyle sortStyle, AcknowledgeType ackType, int limit, int offset) {
        this.m_filters = filters;
        this.m_sortStyle = sortStyle;
        this.m_ackType = ackType;
        this.m_limit = limit;
        this.m_offset = offset;
    }

    public NotificationCriteria(AcknowledgeType ackType, Filter[] filters) {
        this(filters, null, ackType, -1, -1);
    }

    public <E extends Exception> void visit(NotificationCriteriaVisitor<E> visitor) throws E {
        if (this.m_ackType != null) {
            visitor.visitAckType(this.m_ackType);
        }
        for (Filter filter : this.m_filters) {
            visitor.visitFilter(filter);
        }
        if (this.m_sortStyle != null) {
            visitor.visitSortStyle(this.m_sortStyle);
        }
        if (this.m_limit > 0 && this.m_offset > -1) {
            visitor.visitLimit(this.m_limit, this.m_offset);
        }
    }

    public static class BaseNotificationCriteriaVisitor<E extends Exception>
    implements NotificationCriteriaVisitor<E> {
        @Override
        public void visitAckType(AcknowledgeType ackType) throws E {
        }

        @Override
        public void visitFilter(Filter filter) throws E {
        }

        @Override
        public void visitLimit(int limit, int offset) throws E {
        }

        @Override
        public void visitSortStyle(SortStyle sortStyle) throws E {
        }
    }

    public static interface NotificationCriteriaVisitor<E extends Exception> {
        public void visitAckType(AcknowledgeType var1) throws E;

        public void visitFilter(Filter var1) throws E;

        public void visitSortStyle(SortStyle var1) throws E;

        public void visitLimit(int var1, int var2) throws E;
    }
}

