/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public enum SortStyle {
    SEVERITY("severity"),
    TIME("time"),
    NODE("node"),
    NODE_LOCATION("nodelocation"),
    INTERFACE("interface"),
    SERVICE("service"),
    POLLER("poller"),
    ID("id"),
    SYSTEMID("systemid"),
    LOCATION("location"),
    ALARMID("alarmid"),
    REVERSE_SEVERITY("rev_severity"),
    REVERSE_TIME("rev_time"),
    REVERSE_NODE("rev_node"),
    REVERSE_NODE_LOCATION("rev_nodelocation"),
    REVERSE_INTERFACE("rev_interface"),
    REVERSE_SERVICE("rev_service"),
    REVERSE_POLLER("rev_poller"),
    REVERSE_ID("rev_id"),
    REVERSE_SYSTEMID("rev_systemid"),
    REVERSE_LOCATION("rev_location"),
    REVERSE_ALARMID("rev_alarm");

    private static final Map<String, SortStyle> m_sortStylesString;
    private String m_shortName;

    private SortStyle(String shortName) {
        this.m_shortName = shortName;
    }

    public String toString() {
        return "SortStyle." + this.getName();
    }

    public String getName() {
        return this.name();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public static SortStyle getSortStyle(String sortStyleString) {
        Assert.notNull((Object)sortStyleString, (String)"Cannot take null parameters.");
        return m_sortStylesString.get(sortStyleString.toLowerCase());
    }

    protected String getOrderByClause() {
        String clause = null;
        switch (this) {
            case SEVERITY: {
                clause = " ORDER BY EVENTSEVERITY DESC";
                break;
            }
            case REVERSE_SEVERITY: {
                clause = " ORDER BY EVENTSEVERITY ASC";
                break;
            }
            case TIME: {
                clause = " ORDER BY EVENTTIME DESC";
                break;
            }
            case REVERSE_TIME: {
                clause = " ORDER BY EVENTTIME ASC";
                break;
            }
            case NODE: {
                clause = " ORDER BY NODELABEL ASC";
                break;
            }
            case REVERSE_NODE: {
                clause = " ORDER BY NODELABEL DESC";
                break;
            }
            case NODE_LOCATION: {
                clause = " ORDER BY NODE.LOCATION ASC, NODELABEL ASC";
                break;
            }
            case REVERSE_NODE_LOCATION: {
                clause = " ORDER BY NODE.LOCATION DESC, NODELABEL ASC";
                break;
            }
            case INTERFACE: {
                clause = " ORDER BY IPADDR ASC";
                break;
            }
            case REVERSE_INTERFACE: {
                clause = " ORDER BY IPADDR DESC";
                break;
            }
            case SERVICE: {
                clause = " ORDER BY SERVICENAME ASC";
                break;
            }
            case REVERSE_SERVICE: {
                clause = " ORDER BY SERVICENAME DESC";
                break;
            }
            case POLLER: {
                clause = " ORDER BY EVENTDPNAME ASC";
                break;
            }
            case REVERSE_POLLER: {
                clause = " ORDER BY EVENTDPNAME DESC";
                break;
            }
            case ID: {
                clause = " ORDER BY EVENTID DESC";
                break;
            }
            case REVERSE_ID: {
                clause = " ORDER BY EVENTID ASC";
                break;
            }
            case SYSTEMID: {
                clause = " ORDER BY SYSTEMID DESC";
                break;
            }
            case REVERSE_SYSTEMID: {
                clause = " ORDER BY SYSTEMID ASC";
                break;
            }
            case LOCATION: {
                clause = " ORDER BY LOCATION DESC";
                break;
            }
            case REVERSE_LOCATION: {
                clause = " ORDER BY LOCATION ASC";
                break;
            }
            case ALARMID: {
                clause = " ORDER BY ALARM_ID DESC";
                break;
            }
            case REVERSE_ALARMID: {
                clause = " ORDER BY ALARM_ID ASC";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SortStyle: " + (Object)((Object)this));
            }
        }
        return clause;
    }

    static {
        m_sortStylesString = new HashMap<String, SortStyle>();
        for (SortStyle sortStyle : SortStyle.values()) {
            m_sortStylesString.put(sortStyle.getShortName(), sortStyle);
        }
    }
}

