/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.web.alarm.AlarmIdNotFoundException;
import org.opennms.web.servlet.XssRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.view.RedirectView;

public class AlarmDetailController
extends MultiActionController {
    private AlarmRepository m_webAlarmRepository;
    private Logger logger = LoggerFactory.getLogger(AlarmDetailController.class);

    public void setAlarmRepository(AlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug("AlarmDetailController handleRequestInternal called");
        return super.handleRequestInternal(request, response);
    }

    public ModelAndView detail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        OnmsAlarm m_alarm = null;
        XssRequestWrapper safeRequest = new XssRequestWrapper(httpServletRequest);
        String alarmIdString = "";
        List acknowledgments = Collections.emptyList();
        try {
            alarmIdString = safeRequest.getParameter("id");
            int alarmId = Integer.parseInt(alarmIdString);
            acknowledgments = this.m_webAlarmRepository.getAcknowledgments(alarmId);
            m_alarm = this.m_webAlarmRepository.getAlarm(alarmId);
            this.logger.debug("Alarm retrieved: '{}'", (Object)m_alarm.toString());
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)safeRequest.getParameter("id"));
        }
        catch (Throwable e) {
            this.logger.error("Could not retrieve alarm from webAlarmRepository for ID='{}'", (Object)alarmIdString);
        }
        if (m_alarm == null) {
            throw new AlarmIdNotFoundException("Could not find alarm with ID: " + alarmIdString, alarmIdString);
        }
        ModelAndView mv = new ModelAndView("alarm/detail");
        mv.addObject("alarm", (Object)m_alarm);
        mv.addObject("alarmId", (Object)alarmIdString);
        mv.addObject("acknowledgments", (Object)acknowledgments);
        return mv;
    }

    public ModelAndView removeStickyMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeStickyMemo(Integer.valueOf(alarmId));
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveStickyMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String stickyMemoBody = httpServletRequest.getParameter("stickyMemoBody");
            this.m_webAlarmRepository.updateStickyMemo(Integer.valueOf(alarmId), stickyMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView removeJournalMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeReductionKeyMemo(alarmId);
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveJournalMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String journalMemoBody = httpServletRequest.getParameter("journalMemoBody");
            this.m_webAlarmRepository.updateReductionKeyMemo(Integer.valueOf(alarmId), journalMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }
}

