/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.opennms.web.svclayer.CategoryConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/report/database/onlineReport.htm"})
public class OnlineReportController {
    @Autowired
    private ReportWrapperService m_reportWrapperService;
    @Autowired
    private CategoryConfigService m_catConfigService;
    @Autowired
    private CategoryDao m_categoryDao;

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
    }

    @RequestMapping(method={RequestMethod.GET})
    public void handleGet(ModelMap modelMap, @RequestParam(value="reportId") String reportId) {
        modelMap.addAttribute("formats", (Object)this.m_reportWrapperService.getFormats(reportId));
        modelMap.addAttribute("onmsCategories", (Object)this.m_categoryDao.getAllCategoryNames());
        modelMap.addAttribute("categories", (Object)this.m_catConfigService.getCategoriesList());
    }

    @ModelAttribute(value="parameters")
    public ReportParameters getReportParameters(@RequestParam(value="reportId") String reportId) {
        return this.m_reportWrapperService.getParameters(reportId);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"cancel"})
    public ModelAndView onCancel() {
        return new ModelAndView((View)new RedirectView("/report/database/reportList.htm", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, params={"run"})
    public String handleSubmit(ModelMap modelMap, HttpServletResponse response, @ModelAttribute(value="parameters") ReportParameters parameters) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.m_reportWrapperService.runAndRender(parameters, ReportMode.IMMEDIATE, (OutputStream)outputStream);
            if (parameters.getFormat() == ReportFormat.PDF || parameters.getFormat() == ReportFormat.SVG) {
                response.setContentType("application/pdf;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=report.pdf");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            if (parameters.getFormat() == ReportFormat.CSV) {
                response.setContentType("text/csv;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=report.csv");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            response.getOutputStream().write(outputStream.toByteArray());
            String string = null;
            return string;
        }
        catch (ReportException ex) {
            modelMap.addAttribute("errorMessage", (Object)ex.getMessage());
            modelMap.addAttribute("errorCause", (Object)ex.getCause());
            this.handleGet(modelMap, parameters.getReportId());
            String string = "report/database/onlineReport";
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

