/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.List;
import java.util.Map;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.web.svclayer.model.ManageDatabaseReportCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/report/database/manage.htm"})
public class ManageDatabaseReportController {
    private final int m_pageSize = 20;
    @Autowired
    private ReportStoreService reportStoreService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listReports(@RequestParam(value="p", required=false, defaultValue="0") int page, ModelAndView modelAndView) {
        List reportCatalog = this.reportStoreService.getAll();
        Map formatMap = this.reportStoreService.getFormatMap();
        PagedListHolder pagedListHolder = new PagedListHolder(reportCatalog);
        pagedListHolder.setPageSize(20);
        pagedListHolder.setPage(Math.max(page, 0));
        modelAndView.addObject("formatMap", (Object)formatMap);
        modelAndView.addObject("pagedListHolder", (Object)pagedListHolder);
        modelAndView.addObject("command", (Object)new ManageDatabaseReportCommand());
        modelAndView.setViewName("/report/database/manage");
        return modelAndView;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView deleteReports(WebRequest request, @ModelAttribute ManageDatabaseReportCommand command) {
        ModelAndView modelAndView = new ModelAndView();
        if (request.isUserInRole("ROLE_READONLY")) {
            modelAndView.addObject("error", (Object)"You are a read only user and therefore not allowed to delete reports.");
            return this.listReports(0, modelAndView);
        }
        this.reportStoreService.delete(command.getIds());
        modelAndView.addObject("success", (Object)"Reports successfully deleted.");
        return this.listReports(0, modelAndView);
    }
}

