/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.account.selfService;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.User;

public class NewPasswordActionServlet
extends HttpServlet {
    private static final long serialVersionUID = 6803675433403988004L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("NewPasswordActionServlet: Error initialising user factory." + e);
        }
        HttpSession userSession = request.getSession(false);
        UserManager userFactory = UserFactory.getInstance();
        User user = (User)userSession.getAttribute("user.newPassword.jsp");
        String currentPassword = request.getParameter("currentPassword");
        String newPassword = request.getParameter("newPassword");
        if (!request.isUserInRole("ROLE_ADMIN") && user.getRoles().contains("ROLE_READONLY")) {
            throw new ServletException("User " + user.getUserId() + " is read-only");
        }
        if (!userFactory.comparePasswords(user.getUserId(), currentPassword)) {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/account/selfService/newPassword.jsp?action=redo");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            Password pass = new Password();
            pass.setEncryptedPassword(userFactory.encryptedPassword(newPassword, true));
            pass.setSalt(Boolean.valueOf(true));
            user.setPassword(pass);
            userSession.setAttribute("user.newPassword.jsp", (Object)user);
            try {
                userFactory.saveUser(user.getUserId(), user);
            }
            catch (Throwable e) {
                throw new ServletException("Error saving user " + user.getUserId(), e);
            }
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/account/selfService/passwordChanged.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

