/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.filter.IfIndexFilter;
import org.opennms.web.event.filter.InterfaceFilter;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.ServiceFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;

public class EventFactory {
    private EventFactory() {
    }

    public static int getEventCount() throws SQLException {
        return EventFactory.getEventCount(AcknowledgeType.UNACKNOWLEDGED, new Filter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventCount(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int eventCount = 0;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuilder select = new StringBuilder("SELECT COUNT(EVENTID) AS EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                eventCount = rs.getInt("EVENTCOUNT");
            }
            stmt.close();
        }
        finally {
            d.cleanUp();
        }
        return eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getEventCountBySeverity(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] eventCounts = new int[8];
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuilder select = new StringBuilder("SELECT EVENTSEVERITY, COUNT(*) AS EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y'");
            select.append(" GROUP BY EVENTSEVERITY");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                int eventCount;
                int severity = rs.getInt("EVENTSEVERITY");
                eventCounts[severity] = eventCount = rs.getInt("EVENTCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return eventCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event getEvent(int eventId) throws SQLException {
        Event event = null;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT events.*, monitoringsystems.id AS systemId, monitoringsystems.label AS systemLabel, monitoringsystems.location AS location, node.nodeLabel, service.serviceName FROM events LEFT OUTER JOIN monitoringsystems ON events.systemId=monitoringsystems.id LEFT OUTER JOIN node USING (nodeId) LEFT OUTER JOIN service USING (serviceId) WHERE eventId=? ");
            d.watch((Object)stmt);
            stmt.setInt(1, eventId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Event[] events = EventFactory.rs2Events(rs);
            if (events.length > 0) {
                event = events[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getParmsForEventId(int eventId) throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        HashMap result = Maps.newHashMap();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT name, value FROM event_parameters WHERE eventid = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, eventId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                result.put(rs.getString("name"), rs.getString("value"));
            }
        }
        finally {
            d.cleanUp();
        }
        return result;
    }

    public static Event[] getEvents() throws SQLException {
        return EventFactory.getEvents(SortStyle.TIME, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEvents(AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(SortStyle.TIME, ackType);
    }

    public static Event[] getEvents(SortStyle sortStyle) throws SQLException {
        return EventFactory.getEvents(sortStyle, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEvents(SortStyle sortStyle, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEvents(sortStyle, ackType);
    }

    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, new Filter[0]);
    }

    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, filters, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters, int limit, int offset) throws SQLException {
        if (sortStyle == null || ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Event[] events = null;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuilder select = new StringBuilder("          SELECT events.*, node.nodelabel, service.servicename,                  monitoringsystems.id AS systemId,                  monitoringsystems.label AS systemLabel,                  monitoringsystems.location AS location             FROM node RIGHT OUTER JOIN events               ON (events.nodeid = node.nodeid)  LEFT OUTER JOIN monitoringsystems               ON (events.systemid = monitoringsystems.id)  LEFT OUTER JOIN service               ON (service.serviceid = events.serviceid)            WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            select.append(EventFactory.getOrderByClause(sortStyle));
            if (useLimits) {
                select.append(" LIMIT ");
                select.append(limit);
                select.append(" OFFSET ");
                select.append(offset);
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            events = EventFactory.rs2Events(rs);
        }
        finally {
            d.cleanUp();
        }
        return events;
    }

    public static Event[] getEventsForNode(int nodeId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForNode(nodeId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForNode(nodeId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForNode(nodeId, sortStyle, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventCountForNode(int nodeId, AcknowledgeType ackType) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int eventCount = 0;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuilder select = new StringBuilder("SELECT COUNT(EVENTID) AS EVENTCOUNT FROM EVENTS WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            select.append(" AND NODEID=?");
            select.append(" AND EVENTDISPLAY='Y' ");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                eventCount = rs.getInt("EVENTCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return eventCount;
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForInterface(nodeId, ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForInterface(nodeId, ipAddress, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForInterface(int nodeId, int ifIndex, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new IfIndexFilter(ifIndex)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForInterface(String ipAddress) throws SQLException {
        return EventFactory.getEventsForInterface(ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1);
    }

    public static Event[] getEventsForInterface(String ipAddress, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForInterface(ipAddress, SortStyle.ID, ackType, -1, -1);
    }

    public static Event[] getEventsForInterface(String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getEventCountForInterface(int nodeId, String ipAddress, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static int getEventCountForInterface(String ipAddress, AcknowledgeType ackType) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForService(nodeId, ipAddress, serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForService(nodeId, ipAddress, serviceId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForService(int serviceId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForService(serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForService(serviceId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getEventCountForService(int nodeId, String ipAddress, int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static int getEventCountForService(int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static Event[] getEventsForSeverity(int severity) throws SQLException {
        return EventFactory.getEventsForSeverity(severity, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEventsForSeverity(int severity, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForSeverity(severity, SortStyle.ID, ackType);
    }

    public static Event[] getEventsForSeverity(int severity, SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, new Filter[]{new SeverityFilter(severity)});
    }

    public static Event[] getEventsForPoller(String poller) throws SQLException {
        return EventFactory.getEventsForPoller(poller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event[] getEventsForPoller(String poller, boolean includeAcknowledged) throws SQLException {
        if (poller == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Event[] events = null;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuilder select = new StringBuilder("SELECT events.*, monitoringsystems.id AS systemId, monitoringsystems.label AS systemLabel, monitoringsystems.location AS location FROM events LEFT JOIN monitoringsystems ON events.systemid=monitoringsystems.id WHERE monitoringsystems.type='OpenNMS' AND systemLabel=?");
            if (!includeAcknowledged) {
                select.append(" AND EVENTACKUSER IS NULL");
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            select.append(" ORDER BY EVENTID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setString(1, poller);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            events = EventFactory.rs2Events(rs);
        }
        finally {
            d.cleanUp();
        }
        return events;
    }

    public static void acknowledge(Event[] events, String user) throws SQLException {
        EventFactory.acknowledge(events, user, new Date());
    }

    public static void acknowledge(Event[] events, String user, Date time) throws SQLException {
        if (events == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[events.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = events[i].getId();
        }
        EventFactory.acknowledge(ids, user, time);
    }

    public static void acknowledge(int[] eventIds, String user) throws SQLException {
        EventFactory.acknowledge(eventIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(int[] eventIds, String user, Date time) throws SQLException {
        if (eventIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (eventIds.length > 0) {
            StringBuilder update = new StringBuilder("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=?");
            update.append(" WHERE EVENTID IN (");
            update.append(eventIds[0]);
            for (int i = 1; i < eventIds.length; ++i) {
                update.append(",");
                update.append(eventIds[i]);
            }
            update.append(")");
            update.append(" AND EVENTACKUSER IS NULL");
            Connection conn = DataSourceFactory.getInstance().getConnection();
            DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
            try {
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setString(1, user);
                stmt.setTimestamp(2, new Timestamp(time.getTime()));
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    public static void acknowledge(Filter[] filters, String user) throws SQLException {
        EventFactory.acknowledge(filters, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(Filter[] filters, String user, Date time) throws SQLException {
        if (filters == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuilder update = new StringBuilder("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? WHERE");
        update.append(EventFactory.getAcknowledgeTypeClause(AcknowledgeType.UNACKNOWLEDGED));
        for (Filter filter : filters) {
            update.append(" AND");
            update.append(filter.getParamSql());
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            int parameterIndex = 3;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void acknowledgeAll(String user) throws SQLException {
        EventFactory.acknowledgeAll(user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledgeAll(String user, Date time) throws SQLException {
        if (user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? WHERE EVENTACKUSER IS NULL");
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void unacknowledge(Event[] events) throws SQLException {
        if (events == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[events.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = events[i].getId();
        }
        EventFactory.unacknowledge(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(int[] eventIds) throws SQLException {
        if (eventIds == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (eventIds.length > 0) {
            StringBuilder update = new StringBuilder("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL");
            update.append(" WHERE EVENTID IN (");
            update.append(eventIds[0]);
            for (int i = 1; i < eventIds.length; ++i) {
                update.append(",");
                update.append(eventIds[i]);
            }
            update.append(")");
            DBUtils d = new DBUtils(EventFactory.class);
            try {
                Connection conn = DataSourceFactory.getInstance().getConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(Filter[] filters) throws SQLException {
        if (filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuilder update = new StringBuilder("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL WHERE");
        update.append(EventFactory.getAcknowledgeTypeClause(AcknowledgeType.ACKNOWLEDGED));
        for (Filter filter : filters) {
            update.append(" AND");
            update.append(filter.getParamSql());
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void unacknowledgeAll() throws SQLException {
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL WHERE EVENTACKUSER IS NOT NULL");
            d.watch((Object)stmt);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    protected static Event[] rs2Events(ResultSet rs) throws SQLException {
        ArrayList<Event> vector = new ArrayList<Event>();
        while (rs.next()) {
            Event event = new Event();
            event.id = rs.getInt("eventID");
            event.uei = rs.getString("eventUei");
            event.snmp = rs.getString("eventSnmp");
            Timestamp timestamp = rs.getTimestamp("eventTime");
            event.time = new Date(timestamp.getTime());
            event.host = rs.getString("eventHost");
            event.snmphost = rs.getString("eventSnmpHost");
            event.dpName = rs.getString("systemLabel");
            event.parms = EventFactory.getParmsForEventId(event.id);
            Object element = rs.getObject("nodeID");
            event.nodeID = element == null ? Integer.valueOf(0) : (Integer)element;
            event.ipAddr = rs.getString("ipAddr");
            element = rs.getObject("serviceID");
            event.serviceID = element == null ? Integer.valueOf(0) : (Integer)element;
            event.nodeLabel = rs.getString("nodeLabel");
            event.serviceName = rs.getString("serviceName");
            timestamp = rs.getTimestamp("eventCreateTime");
            event.createTime = new Date(timestamp.getTime());
            event.description = rs.getString("eventDescr");
            event.logGroup = rs.getString("eventLoggroup");
            event.logMessage = rs.getString("eventLogmsg");
            event.severity = OnmsSeverity.get((int)rs.getInt("eventSeverity"));
            event.operatorInstruction = rs.getString("eventOperInstruct");
            event.autoAction = rs.getString("eventAutoAction");
            event.operatorAction = rs.getString("eventOperAction");
            event.operatorActionMenuText = rs.getString("eventOperActionMenuText");
            event.notification = rs.getString("eventNotification");
            event.troubleTicket = rs.getString("eventTticket");
            element = rs.getObject("eventTticketState");
            event.troubleTicketState = element == null ? Integer.valueOf(0) : (Integer)element;
            event.forward = rs.getString("eventForward");
            event.mouseOverText = rs.getString("eventMouseOverText");
            event.acknowledgeUser = rs.getString("eventAckUser");
            timestamp = rs.getTimestamp("eventAckTime");
            event.acknowledgeTime = timestamp != null ? new Date(timestamp.getTime()) : null;
            element = rs.getObject("alarmid");
            event.alarmId = element == null ? Integer.valueOf(0) : (Integer)element;
            event.location = rs.getString("location");
            event.systemId = rs.getString("systemId");
            vector.add(event);
        }
        return vector.toArray(new Event[vector.size()]);
    }

    protected static String getOrderByClause(SortStyle sortStyle) {
        if (sortStyle == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return sortStyle.getOrderByClause();
    }

    protected static String getAcknowledgeTypeClause(AcknowledgeType ackType) {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return ackType.getAcknowledgeTypeClause();
    }
}

