/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class DateTimeTag
extends SimpleTagSupport {
    static final String SYSTEM_PROPERTY_DATE_FORMAT = "org.opennms.ui.datettimeformat";
    private static final Logger LOG = Logger.getLogger(DateTimeTag.class.getName());
    private static final DateTimeFormatter DEFAULT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffsetId().toFormatter().withZone(ZoneId.systemDefault());
    private Instant instant;
    private DateTimeFormatter formatter;

    public DateTimeTag() {
        String format = System.getProperty(SYSTEM_PROPERTY_DATE_FORMAT);
        if (format == null) {
            this.formatter = DEFAULT_FORMATTER;
        } else {
            try {
                this.formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, String.format("Can not use System Property %s=%s as dateformat, will fall back to default. Please see also java.time.format.DateTimeFormatter for the correct syntax", SYSTEM_PROPERTY_DATE_FORMAT, format), e);
                this.formatter = DEFAULT_FORMATTER;
            }
        }
    }

    public void doTag() throws IOException {
        String output = this.formatter.format(this.instant);
        this.getJspContext().getOut().write(output);
    }

    public void setInstant(Instant instant) {
        this.instant = instant;
    }

    @Deprecated
    public void setDate(Date date) {
        if (date != null) {
            this.instant = date.toInstant();
        }
    }
}

