/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.navigate;

import javax.servlet.http.HttpServletRequest;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.LocationBasedNavBarEntry;
import org.opennms.web.navigate.NavBarEntry;

public class MenuDropdownNavBarEntry
extends LocationBasedNavBarEntry {
    private String m_contents = null;

    @Override
    public String getDisplayString() {
        if (this.getName() == null || this.m_contents == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"nav-dropdown\">");
        sb.append("<a href=\"");
        if (this.getUrl() == null) {
            sb.append("#");
        } else {
            sb.append(this.getUrl());
        }
        sb.append("\" class=\"nav-dropdown\">");
        sb.append(this.getName());
        sb.append(" ");
        sb.append("<span class=\"nav-item\">\u25bc</span>");
        sb.append("</a>");
        sb.append("<ul>");
        sb.append(this.m_contents);
        sb.append("</ul>");
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public DisplayStatus evaluate(HttpServletRequest request) {
        boolean display = false;
        if (this.hasEntries()) {
            StringBuilder sb = new StringBuilder();
            for (NavBarEntry entry : this.getEntries()) {
                DisplayStatus status = entry.evaluate(request);
                switch (status) {
                    case DISPLAY_LINK: {
                        sb.append("<li><a href=\"" + entry.getUrl() + "\">" + entry.getName() + "</a></li>");
                        display = true;
                        break;
                    }
                    case DISPLAY_NO_LINK: {
                        sb.append("<li>" + entry.getName() + "</li>");
                        display = true;
                        break;
                    }
                }
            }
            this.m_contents = sb.toString();
        }
        return display ? DisplayStatus.DISPLAY_NO_LINK : DisplayStatus.NO_DISPLAY;
    }
}

