/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import freemarker.ext.beans.StringModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.web.api.OnmsHeaderProvider;
import org.opennms.web.api.Util;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.NavBarEntry;
import org.opennms.web.navigate.NavBarModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.AbstractView;

public class NavBarController
extends AbstractController
implements InitializingBean,
OnmsHeaderProvider {
    private List<NavBarEntry> m_navBarItems;
    private FreemarkerView m_view;

    public void afterPropertiesSet() throws IOException {
        Assert.state((this.m_navBarItems != null ? 1 : 0) != 0, (String)"navBarItems property has not been set");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        cfg.setClassForTemplateLoading(NavBarController.class, "");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        Template template = cfg.getTemplate("navbar.ftl");
        this.m_view = new FreemarkerView(template);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView((View)this.m_view, this.createModel(request));
    }

    private Map<String, Object> createModel(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        LinkedHashMap<NavBarEntry, DisplayStatus> navBar = new LinkedHashMap<NavBarEntry, DisplayStatus>();
        for (NavBarEntry entry : this.getNavBarItems()) {
            navBar.put(entry, entry.evaluate(request));
        }
        model.put("model", new NavBarModel(request, navBar));
        model.put("request", request);
        model.put("baseHref", Util.calculateUrlBase((HttpServletRequest)request));
        model.put("isProvision", request.isUserInRole("ROLE_PROVISION"));
        model.put("isAdmin", request.isUserInRole("ROLE_ADMIN"));
        String noticeStatus = "Unknown";
        try {
            noticeStatus = NotifdConfigFactory.getPrettyStatus();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        model.put("noticeStatus", noticeStatus);
        model.put("shouldDisplay", new ShouldDisplayEntryMethod(request));
        return model;
    }

    public List<NavBarEntry> getNavBarItems() {
        return this.m_navBarItems;
    }

    public void setNavBarItems(List<NavBarEntry> navBarItems) {
        this.m_navBarItems = navBarItems;
    }

    public String getHeaderHtml(HttpServletRequest request) throws Exception {
        return this.m_view.renderMergedOutputModel(this.createModel(request), request);
    }

    public static class ShouldDisplayEntryMethod
    implements TemplateMethodModelEx {
        private final HttpServletRequest request;

        public ShouldDisplayEntryMethod(HttpServletRequest request) {
            this.request = request;
        }

        public Boolean exec(List arguments) throws TemplateModelException {
            DisplayStatus entryDisplayStatus;
            if (arguments.size() == 1) {
                NavBarEntry entry = (NavBarEntry)((StringModel)arguments.get(0)).getWrappedObject();
                entryDisplayStatus = entry.evaluate(this.request);
            } else if (arguments.size() == 2) {
                entryDisplayStatus = (DisplayStatus)((StringModel)arguments.get(1)).getWrappedObject();
            } else {
                throw new TemplateModelException("Wrong arguments");
            }
            return entryDisplayStatus != DisplayStatus.NO_DISPLAY;
        }
    }

    private static class FreemarkerView
    extends AbstractView {
        private final Template template;

        public FreemarkerView(Template template) {
            this.template = template;
        }

        public String renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request) throws Exception {
            StringWriter writer = new StringWriter();
            this.renderMergedOutputModel(model, request, writer);
            return writer.toString();
        }

        public void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, Writer writer) throws Exception {
            this.template.process(model, writer);
        }

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            this.renderMergedOutputModel(model, request, response.getWriter());
        }
    }
}

