/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class ServiceFilter
extends EqualsFilter<Integer> {
    public static final String TYPE = "service";
    private ServletContext m_servletContext;

    public ServiceFilter(int serviceId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "OUTAGES.SERVICEID", "serviceType.id", serviceId);
        this.m_servletContext = servletContext;
    }

    @Override
    public String getTextDescription() {
        int serviceId = this.getServiceId();
        String serviceName = Integer.toString(serviceId);
        serviceName = NetworkElementFactory.getInstance(this.m_servletContext).getServiceNameFromId(serviceId);
        return "service is " + serviceName;
    }

    @Override
    public String toString() {
        return "<ServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

