/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.graph;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.charts.ChartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurdyChartServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PurdyChartServlet.class);
    private static final long serialVersionUID = 2449309268355063862L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String chartName = request.getParameter("chart-name");
        String buffered = request.getParameter("buffered");
        if (chartName == null) {
            LOG.warn("doGet: request doesn't contain a chart-name parameter.");
            return;
        }
        if (buffered == null) {
            buffered = "0";
        }
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        LOG.debug("doGet: displaying chart: {}", (Object)chartName);
        try {
            ChartUtils.getBarChartPNG((String)chartName, (OutputStream)out);
        }
        catch (IOException e) {
            LOG.error("Error reading chart-configuration.xml: ", (Throwable)e);
        }
        catch (SQLException e) {
            LOG.error("Error in SQL for chart: {}", (Object)chartName, (Object)e);
        }
        out.flush();
        out.close();
    }
}

