/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.web.api.Util;
import org.opennms.web.category.CategoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTCPostServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(RTCPostServlet.class);
    private static final long serialVersionUID = 5550051932055498432L;
    protected CategoryModel model;

    public void init() throws ServletException {
        try {
            this.model = CategoryModel.getInstance();
        }
        catch (IOException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            LOG.error("Request with no path info");
            response.sendError(400, "No Category name given in path");
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1, pathInfo.length());
        }
        String categoryName = Util.decode((String)pathInfo);
        Category category = null;
        try (ServletInputStream inStream = request.getInputStream();
             InputStreamReader isr = new InputStreamReader((InputStream)inStream);){
            EuiLevel level = (EuiLevel)JaxbUtils.unmarshal(EuiLevel.class, (Reader)isr);
            category = (Category)level.getCategory().get(0);
        }
        if (!categoryName.equals(category.getCatlabel())) {
            LOG.error("Request did not supply information for category specified in path info");
            response.sendError(400, "No category info found for " + categoryName);
            return;
        }
        this.model.updateCategory(category);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("Category data parsed successfully.");
        out.close();
        LOG.info("Successfully received information for {}", (Object)categoryName);
    }
}

