/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.trend;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.trend.TrendConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class TrendBoxController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(TrendBoxController.class);
    private final File CONFIG_FILE = new File("etc/trend-configuration.xml");

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("trend/trend-box");
        List filteredTrendDefinitions = this.getConfiguration().getTrendDefinitions().stream().filter(trendDefinition -> trendDefinition.isVisible()).collect(Collectors.toList());
        modelAndView.addObject("trendDefinitions", filteredTrendDefinitions);
        return modelAndView;
    }

    public TrendConfiguration getConfiguration() {
        return (TrendConfiguration)JaxbUtils.unmarshal(TrendConfiguration.class, (File)this.CONFIG_FILE);
    }

    public void afterPropertiesSet() {
    }
}

