/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.web.api.Util;
import org.opennms.web.enlinkd.BridgeElementNode;
import org.opennms.web.enlinkd.BridgeLinkNode;
import org.opennms.web.enlinkd.BridgeLinkRemoteNode;
import org.opennms.web.enlinkd.CdpElementNode;
import org.opennms.web.enlinkd.CdpLinkNode;
import org.opennms.web.enlinkd.EnLinkdElementFactoryInterface;
import org.opennms.web.enlinkd.IsisElementNode;
import org.opennms.web.enlinkd.IsisLinkNode;
import org.opennms.web.enlinkd.LldpElementNode;
import org.opennms.web.enlinkd.LldpLinkNode;
import org.opennms.web.enlinkd.OspfElementNode;
import org.opennms.web.enlinkd.OspfLinkNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class EnLinkdElementFactory
implements InitializingBean,
EnLinkdElementFactoryInterface {
    private static final Logger LOG = LoggerFactory.getLogger(EnLinkdElementFactory.class);
    @Autowired
    private OspfElementDao m_ospfElementDao;
    @Autowired
    private OspfLinkDao m_ospfLinkDao;
    @Autowired
    private LldpElementDao m_lldpElementDao;
    @Autowired
    private LldpLinkDao m_lldpLinkDao;
    @Autowired
    private CdpElementDao m_cdpElementDao;
    @Autowired
    private CdpLinkDao m_cdpLinkDao;
    @Autowired
    private BridgeElementDao m_bridgeElementDao;
    @Autowired
    private BridgeTopologyDao m_bridgetopologyDao;
    @Autowired
    private IpNetToMediaDao m_ipNetToMediaDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private IsIsElementDao m_isisElementDao;
    @Autowired
    private IsIsLinkDao m_isisLinkDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static EnLinkdElementFactoryInterface getInstance(ServletContext servletContext) {
        return EnLinkdElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static EnLinkdElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (EnLinkdElementFactoryInterface)appContext.getBean(EnLinkdElementFactoryInterface.class);
    }

    @Override
    public OspfElementNode getOspfElement(int nodeId) {
        return this.convertFromModel(this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private OspfElementNode convertFromModel(OspfElement ospf) {
        if (ospf == null) {
            return null;
        }
        OspfElementNode ospfNode = new OspfElementNode();
        ospfNode.setOspfRouterId(InetAddressUtils.str((InetAddress)ospf.getOspfRouterId()));
        ospfNode.setOspfVersionNumber(ospf.getOspfVersionNumber());
        ospfNode.setOspfAdminStat(OspfElement.Status.getTypeString((Integer)ospf.getOspfAdminStat().getValue()));
        ospfNode.setOspfCreateTime(Util.formatDateToUIString((Date)ospf.getOspfNodeCreateTime()));
        ospfNode.setOspfLastPollTime(Util.formatDateToUIString((Date)ospf.getOspfNodeLastPollTime()));
        return ospfNode;
    }

    @Override
    public List<OspfLinkNode> getOspfLinks(int nodeId) {
        ArrayList<OspfLinkNode> nodelinks = new ArrayList<OspfLinkNode>();
        for (OspfLink link : this.m_ospfLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    public OspfLinkNode create(int nodeid, OspfLink link) {
        OspfLinkNode linknode = new OspfLinkNode();
        OnmsSnmpInterface snmpiface = null;
        String ipaddr = InetAddressUtils.str((InetAddress)link.getOspfIpAddr());
        if (link.getOspfIfIndex() != null) {
            snmpiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeid), link.getOspfIfIndex());
        } else if (link.getOspfAddressLessIndex() > 0) {
            snmpiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeid), link.getOspfAddressLessIndex());
        }
        if (snmpiface != null) {
            if (link.getOspfAddressLessIndex() > 0) {
                linknode.setOspfLocalPort(this.getPortString(snmpiface, "address less", null));
            } else {
                linknode.setOspfLocalPort(this.getPortString(snmpiface, "ip", ipaddr));
            }
            linknode.setOspfLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, snmpiface.getIfIndex()));
        } else if (link.getOspfAddressLessIndex() > 0) {
            linknode.setOspfLocalPort(this.getPortString(link.getOspfAddressLessIndex(), "address less", null));
        } else if (link.getOspfIfIndex() != null && ipaddr != null) {
            linknode.setOspfLocalPort(this.getPortString(link.getOspfIfIndex(), "ip", ipaddr));
            linknode.setOspfLocalPortUrl(this.getIpInterfaceUrl(nodeid, ipaddr));
        } else if (ipaddr != null) {
            linknode.setOspfLocalPort(this.getIdString("ip", ipaddr));
            linknode.setOspfLocalPortUrl(this.getIpInterfaceUrl(nodeid, ipaddr));
        }
        if (link.getOspfIpMask() != null) {
            linknode.setOspfLinkInfo(this.getIdString("mask", InetAddressUtils.str((InetAddress)link.getOspfIpMask())));
        } else {
            linknode.setOspfLinkInfo(this.getIdString("No mask", null));
        }
        linknode.setOspfLinkCreateTime(Util.formatDateToUIString((Date)link.getOspfLinkCreateTime()));
        linknode.setOspfLinkLastPollTime(Util.formatDateToUIString((Date)link.getOspfLinkLastPollTime()));
        return linknode;
    }

    @Transactional
    public OspfLinkNode convertFromModel(int nodeid, OspfLink link) {
        OspfLinkNode linknode = this.create(nodeid, link);
        Integer remNodeid = null;
        String remNodeLabel = null;
        List remOspfElements = this.m_ospfElementDao.findAllByRouterId(link.getOspfRemRouterId());
        if (remOspfElements.size() == 1) {
            OspfElement remOspfElement = (OspfElement)remOspfElements.iterator().next();
            remNodeid = remOspfElement.getNode().getId();
            remNodeLabel = remOspfElement.getNode().getLabel();
        }
        if (remNodeid != null) {
            linknode.setOspfRemRouterId(this.getHostString(remNodeLabel, "router id", InetAddressUtils.str((InetAddress)link.getOspfRemRouterId())));
            linknode.setOspfRemRouterUrl(this.getNodeUrl(remNodeid));
        } else {
            linknode.setOspfRemRouterId(this.getIdString("router id", InetAddressUtils.str((InetAddress)link.getOspfRemRouterId())));
        }
        String remipaddr = InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr());
        OnmsSnmpInterface remsnmpiface = null;
        if (remNodeid != null) {
            if (link.getOspfRemAddressLessIndex() > 0) {
                remsnmpiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(remNodeid, link.getOspfAddressLessIndex());
            } else {
                OnmsIpInterface remipiface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(remNodeid, remipaddr);
                if (remipiface != null) {
                    remsnmpiface = remipiface.getSnmpInterface();
                }
            }
        }
        if (remsnmpiface != null) {
            if (link.getOspfRemAddressLessIndex() > 0) {
                linknode.setOspfRemPort(this.getPortString(remsnmpiface, "address less", null));
            } else {
                linknode.setOspfRemPort(this.getPortString(remsnmpiface, "ip", remipaddr));
            }
            linknode.setOspfRemPortUrl(this.getSnmpInterfaceUrl(remNodeid, remsnmpiface.getIfIndex()));
        } else if (link.getOspfAddressLessIndex() > 0) {
            linknode.setOspfRemPort(this.getPortString(link.getOspfRemAddressLessIndex(), "address less", null));
        } else if (remipaddr != null) {
            linknode.setOspfRemPort(this.getIdString("ip", remipaddr));
            if (remNodeid != null) {
                linknode.setOspfRemPortUrl(this.getIpInterfaceUrl(remNodeid, remipaddr));
            }
        }
        return linknode;
    }

    @Override
    public CdpElementNode getCdpElement(int nodeId) {
        return this.convertFromModel(this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private CdpElementNode convertFromModel(CdpElement cdp) {
        if (cdp == null) {
            return null;
        }
        CdpElementNode cdpNode = new CdpElementNode();
        cdpNode.setCdpGlobalRun(OspfElement.TruthValue.getTypeString((Integer)cdp.getCdpGlobalRun().getValue()));
        cdpNode.setCdpGlobalDeviceId(cdp.getCdpGlobalDeviceId());
        if (cdp.getCdpGlobalDeviceIdFormat() != null) {
            cdpNode.setCdpGlobalDeviceIdFormat(CdpElement.CdpGlobalDeviceIdFormat.getTypeString((Integer)cdp.getCdpGlobalDeviceIdFormat().getValue()));
        } else {
            cdpNode.setCdpGlobalDeviceIdFormat("&nbsp");
        }
        cdpNode.setCdpCreateTime(Util.formatDateToUIString((Date)cdp.getCdpNodeCreateTime()));
        cdpNode.setCdpLastPollTime(Util.formatDateToUIString((Date)cdp.getCdpNodeLastPollTime()));
        return cdpNode;
    }

    @Override
    public List<CdpLinkNode> getCdpLinks(int nodeId) {
        ArrayList<CdpLinkNode> nodelinks = new ArrayList<CdpLinkNode>();
        for (CdpLink link : this.m_cdpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    public CdpLinkNode create(int nodeid, CdpLink link) {
        CdpLinkNode linknode = new CdpLinkNode();
        linknode.setCdpLocalPort(this.getPortString(link.getCdpInterfaceName(), link.getCdpCacheIfIndex(), null, null));
        OnmsSnmpInterface snmpiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeid), link.getCdpCacheIfIndex());
        Set ipifaces = snmpiface.getIpInterfaces();
        if (snmpiface != null) {
            if (ipifaces.isEmpty() || ipifaces.size() > 1) {
                linknode.setCdpLocalPort(this.getPortString(snmpiface, null, null));
            } else {
                linknode.setCdpLocalPort(this.getPortString(snmpiface, "ip", InetAddressUtils.str((InetAddress)((OnmsIpInterface)ipifaces.iterator().next()).getIpAddress())));
            }
            linknode.setCdpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getCdpCacheIfIndex()));
        }
        linknode.setCdpCreateTime(Util.formatDateToUIString((Date)link.getCdpLinkCreateTime()));
        linknode.setCdpLastPollTime(Util.formatDateToUIString((Date)link.getCdpLinkLastPollTime()));
        linknode.setCdpCachePlatform(link.getCdpCacheDevicePlatform() + " -> " + link.getCdpCacheVersion());
        return linknode;
    }

    @Transactional
    public CdpLinkNode convertFromModel(int nodeid, CdpLink link) {
        CdpLinkNode linknode = this.create(nodeid, link);
        linknode.setCdpCacheDevice(link.getCdpCacheDeviceId());
        linknode.setCdpCacheDevicePort(this.getPortString(link.getCdpCacheDevicePort(), null, CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()), link.getCdpCacheAddress()));
        CdpElement cdpCacheElement = this.m_cdpElementDao.findByGlobalDeviceId(link.getCdpCacheDeviceId());
        if (cdpCacheElement != null) {
            linknode.setCdpCacheDevice(this.getHostString(cdpCacheElement.getNode().getLabel(), "Cisco Device Id", link.getCdpCacheDeviceId()));
            linknode.setCdpCacheDeviceUrl(this.getNodeUrl(cdpCacheElement.getNode().getId()));
            OnmsSnmpInterface cdpcachesnmp = this.getFromCdpCacheDevicePort(cdpCacheElement.getNode().getId(), link.getCdpCacheDevicePort());
            if (cdpcachesnmp != null) {
                linknode.setCdpCacheDevicePort(this.getPortString(cdpcachesnmp, CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()), link.getCdpCacheAddress()));
                linknode.setCdpCacheDevicePortUrl(this.getSnmpInterfaceUrl(cdpCacheElement.getNode().getId(), cdpcachesnmp.getIfIndex()));
            }
        }
        return linknode;
    }

    @Override
    public LldpElementNode getLldpElement(int nodeId) {
        return this.convertFromModel(this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private LldpElementNode convertFromModel(LldpElement lldp) {
        if (lldp == null) {
            return null;
        }
        LldpElementNode lldpNode = new LldpElementNode();
        lldpNode.setLldpChassisId(this.getIdString(LldpUtils.LldpChassisIdSubType.getTypeString((Integer)lldp.getLldpChassisIdSubType().getValue()), lldp.getLldpChassisId()));
        lldpNode.setLldpSysName(lldp.getLldpSysname());
        lldpNode.setLldpCreateTime(Util.formatDateToUIString((Date)lldp.getLldpNodeCreateTime()));
        lldpNode.setLldpLastPollTime(Util.formatDateToUIString((Date)lldp.getLldpNodeLastPollTime()));
        return lldpNode;
    }

    @Override
    public List<LldpLinkNode> getLldpLinks(int nodeId) {
        ArrayList<LldpLinkNode> nodelinks = new ArrayList<LldpLinkNode>();
        for (LldpLink link : this.m_lldpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    private LldpLinkNode create(int nodeid, LldpLink link) {
        LldpLinkNode linknode = new LldpLinkNode();
        linknode.setLldpLocalPort(this.getPortString(link.getLldpPortDescr(), link.getLldpPortIfindex(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpPortIdSubType().getValue()), link.getLldpPortId()));
        linknode.setLldpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getLldpPortIfindex()));
        linknode.setLldpRemInfo(link.getLldpRemSysname());
        linknode.setLldpCreateTime(Util.formatDateToUIString((Date)link.getLldpLinkCreateTime()));
        linknode.setLldpLastPollTime(Util.formatDateToUIString((Date)link.getLldpLinkLastPollTime()));
        return linknode;
    }

    @Transactional
    private LldpLinkNode convertFromModel(int nodeid, LldpLink link) {
        LldpLinkNode linknode = this.create(nodeid, link);
        linknode.setLldpRemChassisId(this.getIdString(LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()), link.getLldpRemChassisId()));
        linknode.setLldpRemPort(this.getPortString(link.getLldpRemPortDescr(), null, LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpRemPortIdSubType().getValue()), link.getLldpRemPortId()));
        OnmsNode remNode = null;
        List lldpremelements = this.m_lldpElementDao.findByChassisId(link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType());
        if (lldpremelements.size() == 1) {
            remNode = ((LldpElement)lldpremelements.get(0)).getNode();
        } else {
            Criteria criteria = new Criteria(OnmsNode.class).addRestriction((Restriction)new EqRestriction("sysName", (Object)link.getLldpRemSysname()));
            List nodes = this.m_nodeDao.findMatching(criteria);
            if (nodes.size() == 1) {
                remNode = (OnmsNode)nodes.get(0);
            }
        }
        if (remNode != null) {
            linknode.setLldpRemChassisId(this.getHostString(remNode.getLabel(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()), link.getLldpRemChassisId()));
            linknode.setLldpRemChassisIdUrl(this.getNodeUrl(remNode.getId()));
            if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
                try {
                    Integer remIfIndex = Integer.getInteger(link.getLldpRemPortId());
                    linknode.setLldpRemPortUrl(this.getSnmpInterfaceUrl((int)remNode.getId(), remIfIndex));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return linknode;
    }

    @Override
    public IsisElementNode getIsisElement(int nodeId) {
        return this.convertFromModel(this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private IsisElementNode convertFromModel(IsIsElement isis) {
        if (isis == null) {
            return null;
        }
        IsisElementNode isisNode = new IsisElementNode();
        isisNode.setIsisSysID(isis.getIsisSysID());
        isisNode.setIsisSysAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)isis.getIsisSysAdminState().getValue()));
        isisNode.setIsisCreateTime(Util.formatDateToUIString((Date)isis.getIsisNodeCreateTime()));
        isisNode.setIsisLastPollTime(Util.formatDateToUIString((Date)isis.getIsisNodeLastPollTime()));
        return isisNode;
    }

    @Override
    public List<IsisLinkNode> getIsisLinks(int nodeId) {
        ArrayList<IsisLinkNode> nodelinks = new ArrayList<IsisLinkNode>();
        for (IsIsLink link : this.m_isisLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    @Transactional
    private IsisLinkNode convertFromModel(int nodeid, IsIsLink link) {
        IsIsLink adjLink;
        IsisLinkNode linknode = new IsisLinkNode();
        linknode.setIsisCircIfIndex(link.getIsisCircIfIndex());
        linknode.setIsisCircAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)link.getIsisCircAdminState().getValue()));
        IsIsElement isiselement = this.m_isisElementDao.findByIsIsSysId(link.getIsisISAdjNeighSysID());
        if (isiselement != null) {
            linknode.setIsisISAdjNeighSysID(this.getHostString(isiselement.getNode().getLabel(), "ISSysID", link.getIsisISAdjNeighSysID()));
            linknode.setIsisISAdjUrl(this.getNodeUrl(isiselement.getNode().getId()));
        } else {
            linknode.setIsisISAdjNeighSysID(link.getIsisISAdjNeighSysID());
        }
        linknode.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)link.getIsisISAdjNeighSysType().getValue()));
        linknode.setIsisISAdjNeighSNPAAddress(link.getIsisISAdjNeighSNPAAddress());
        linknode.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)link.getIsisISAdjState().getValue()).toString());
        linknode.setIsisISAdjNbrExtendedCircID(link.getIsisISAdjNbrExtendedCircID());
        OnmsSnmpInterface remiface = null;
        if (isiselement != null && (adjLink = this.m_isisLinkDao.get(isiselement.getNode().getId(), link.getIsisISAdjIndex(), link.getIsisCircIndex())) != null) {
            remiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(isiselement.getNode().getId(), adjLink.getIsisCircIfIndex());
        }
        if (remiface == null) {
            remiface = this.getFromPhysAddress(link.getIsisISAdjNeighSNPAAddress());
        }
        if (remiface != null) {
            linknode.setIsisISAdjNeighPort(this.getPortString(remiface, null, null));
            linknode.setIsisISAdjUrl(this.getSnmpInterfaceUrl(remiface.getNode().getId(), remiface.getIfIndex()));
        } else {
            linknode.setIsisISAdjNeighPort("(Isis IS Adj Index: " + link.getIsisISAdjIndex() + ")");
        }
        linknode.setIsisLinkCreateTime(Util.formatDateToUIString((Date)link.getIsisLinkCreateTime()));
        linknode.setIsisLinkLastPollTime(Util.formatDateToUIString((Date)link.getIsisLinkLastPollTime()));
        return linknode;
    }

    @Override
    public List<BridgeElementNode> getBridgeElements(int nodeId) {
        ArrayList<BridgeElementNode> nodes = new ArrayList<BridgeElementNode>();
        for (BridgeElement bridge : this.m_bridgeElementDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodes.add(this.convertFromModel(bridge));
        }
        return nodes;
    }

    private BridgeElementNode convertFromModel(BridgeElement bridge) {
        if (bridge == null) {
            return null;
        }
        BridgeElementNode bridgeNode = new BridgeElementNode();
        bridgeNode.setBaseBridgeAddress(bridge.getBaseBridgeAddress());
        bridgeNode.setBaseNumPorts(bridge.getBaseNumPorts());
        bridgeNode.setBaseType(BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)bridge.getBaseType().getValue()));
        bridgeNode.setVlan(bridge.getVlan());
        bridgeNode.setVlanname(bridge.getVlanname());
        if (bridge.getStpProtocolSpecification() != null) {
            bridgeNode.setStpProtocolSpecification(BridgeElement.BridgeDot1dStpProtocolSpecification.getTypeString((Integer)bridge.getStpProtocolSpecification().getValue()));
        }
        bridgeNode.setStpPriority(bridge.getStpPriority());
        bridgeNode.setStpDesignatedRoot(bridge.getStpDesignatedRoot());
        bridgeNode.setStpRootCost(bridge.getStpRootCost());
        bridgeNode.setStpRootPort(bridge.getStpRootPort());
        bridgeNode.setBridgeNodeCreateTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeCreateTime()));
        bridgeNode.setBridgeNodeLastPollTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeLastPollTime()));
        return bridgeNode;
    }

    @Transactional
    private BridgeLinkNode convertFromModel(Integer nodeid, SharedSegment segment) throws BridgeTopologyException {
        OnmsSnmpInterface iface;
        BridgeLinkNode linknode = new BridgeLinkNode();
        BridgePort bridgePort = segment.getBridgePort(nodeid);
        OnmsSnmpInterface onmsSnmpInterface = iface = bridgePort.getBridgePortIfIndex() == null ? null : this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(bridgePort.getNodeId(), bridgePort.getBridgePortIfIndex());
        if (iface != null) {
            linknode.setBridgeLocalPort(this.getPortString(iface, "bridgeport", bridgePort.getBridgePort().toString()));
            linknode.setBridgeLocalPortUrl(this.getSnmpInterfaceUrl(bridgePort.getNodeId(), bridgePort.getBridgePortIfIndex()));
        } else {
            linknode.setBridgeLocalPort(this.getPortString("port", bridgePort.getBridgePortIfIndex(), "bridgeport", bridgePort.getBridgePort().toString()));
        }
        BridgeElement bridgeElement = this.m_bridgeElementDao.getByNodeIdVlan(bridgePort.getNodeId(), bridgePort.getVlan());
        if (bridgeElement != null) {
            linknode.setBridgeInfo(bridgeElement.getVlanname());
        }
        return this.addBridgeRemotesNodes(nodeid, null, linknode, segment);
    }

    @Transactional
    private BridgeLinkNode convertFromModel(Integer nodeid, String mac, List<OnmsIpInterface> ipaddrs, SharedSegment segment) {
        BridgeLinkNode linknode = new BridgeLinkNode();
        if (ipaddrs.size() == 0) {
            linknode.setBridgeLocalPort(this.getIdString("mac", mac));
        } else if (ipaddrs.size() == 1) {
            OnmsIpInterface ipiface = ipaddrs.iterator().next();
            if (ipiface != null) {
                OnmsSnmpInterface snmpiface = ipiface.getSnmpInterface();
                if (snmpiface != null) {
                    linknode.setBridgeLocalPort(this.getPortString(snmpiface, "mac", mac));
                    linknode.setBridgeLocalPortUrl(this.getSnmpInterfaceUrl(snmpiface.getNodeId(), snmpiface.getIfIndex()));
                } else {
                    linknode.setBridgeLocalPort(this.getPortString(InetAddressUtils.str((InetAddress)ipiface.getIpAddress()), ipiface.getIfIndex(), "mac", mac));
                    linknode.setBridgeLocalPortUrl(this.getIpInterfaceUrl(ipiface.getNodeId(), InetAddressUtils.str((InetAddress)ipiface.getIpAddress())));
                }
            }
        } else {
            linknode.setBridgeLocalPort(this.getPortString(this.getIpListAsStringFromIpInterface(ipaddrs), null, "mac", mac));
        }
        return this.addBridgeRemotesNodes(nodeid, mac, linknode, segment);
    }

    @Transactional
    private BridgeLinkNode addBridgeRemotesNodes(Integer nodeid, String mac, BridgeLinkNode linknode, SharedSegment segment) {
        linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)segment.getCreateTime()));
        linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)segment.getLastPollTime()));
        for (BridgePort remport : segment.getBridgePortsOnSegment()) {
            OnmsSnmpInterface remiface;
            if (nodeid.intValue() == remport.getNodeId().intValue()) continue;
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            BridgeElement remBridgeElement = this.m_bridgeElementDao.getByNodeIdVlan(remport.getNodeId(), remport.getVlan());
            if (remBridgeElement != null) {
                remlinknode.setBridgeRemote(this.getHostString(remBridgeElement.getNode().getLabel(), "bridge base address", remBridgeElement.getBaseBridgeAddress()));
            } else {
                remlinknode.setBridgeRemote(this.getIdString("nodeid", remport.getNodeId().toString()));
            }
            remlinknode.setBridgeRemoteUrl(this.getNodeUrl(remport.getNodeId()));
            OnmsSnmpInterface onmsSnmpInterface = remiface = remport.getBridgePortIfIndex() == null ? null : this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(remport.getNodeId(), remport.getBridgePortIfIndex());
            if (remiface != null) {
                remlinknode.setBridgeRemotePort(this.getPortString(remiface, "bridgeport", remport.getBridgePort().toString()));
                remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(remport.getNodeId(), remport.getBridgePortIfIndex()));
            } else {
                remlinknode.setBridgeRemotePort(this.getPortString(null, remport.getBridgePortIfIndex(), "bridgeport", remport.getBridgePort().toString()));
            }
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
        HashMap macsToIpNetTOMediaMap = new HashMap();
        for (String sharedmac : segment.getMacsOnSegment()) {
            if (sharedmac.equals(mac)) continue;
            macsToIpNetTOMediaMap.put(sharedmac, new ArrayList(this.m_ipNetToMediaDao.findByPhysAddress(sharedmac)));
        }
        for (String sharedmac : macsToIpNetTOMediaMap.keySet()) {
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            if (((List)macsToIpNetTOMediaMap.get(sharedmac)).isEmpty()) {
                OnmsSnmpInterface snmp = this.getFromPhysAddress(sharedmac);
                if (snmp == null) {
                    remlinknode.setBridgeRemote(this.getIdString("mac", sharedmac));
                } else {
                    remlinknode.setBridgeRemote(this.getHostString(snmp.getNode().getLabel(), "mac", sharedmac));
                    remlinknode.setBridgeRemoteUrl(this.getNodeUrl(snmp.getNode().getId()));
                    remlinknode.setBridgeRemotePort(this.getPortString(snmp, null, null));
                    remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(snmp.getNode().getId(), snmp.getIfIndex()));
                }
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            ArrayList remipaddrs = new ArrayList();
            for (IpNetToMedia ipnettomedia : (List)macsToIpNetTOMediaMap.get(sharedmac)) {
                remipaddrs.addAll(this.m_ipInterfaceDao.findByIpAddress(ipnettomedia.getNetAddress().getHostAddress()));
            }
            if (remipaddrs.size() == 0) {
                remlinknode.setBridgeRemote(this.getIdString("mac", sharedmac));
                remlinknode.setBridgeRemotePort(this.getIpListAsStringFromIpNetToMedia((List)macsToIpNetTOMediaMap.get(sharedmac)));
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            if (remipaddrs.size() == 1) {
                OnmsIpInterface remiface = (OnmsIpInterface)remipaddrs.iterator().next();
                remlinknode.setBridgeRemote(this.getHostString(remiface.getNode().getLabel(), "mac", sharedmac));
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(remiface.getNodeId()));
                OnmsSnmpInterface remsnmpiface = remiface.getSnmpInterface();
                if (remsnmpiface != null) {
                    remlinknode.setBridgeRemotePort(this.getPortString(remsnmpiface, "ip", InetAddressUtils.str((InetAddress)remiface.getIpAddress())));
                    remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(remiface.getNodeId(), remsnmpiface.getIfIndex()));
                } else {
                    remlinknode.setBridgeRemotePort(this.getPortString(InetAddressUtils.str((InetAddress)remiface.getIpAddress()), remiface.getIfIndex(), null, null));
                    remlinknode.setBridgeRemotePortUrl(this.getIpInterfaceUrl(remiface.getNodeId(), InetAddressUtils.str((InetAddress)remiface.getIpAddress())));
                }
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            HashSet<String> labels = new HashSet<String>();
            for (OnmsIpInterface remiface : remipaddrs) {
                labels.add(remiface.getNode().getLabel());
            }
            if (labels.size() == 1) {
                remlinknode.setBridgeRemote(this.getHostString((String)labels.iterator().next(), "mac", sharedmac));
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(((OnmsIpInterface)remipaddrs.iterator().next()).getNodeId()));
            }
            remlinknode.setBridgeRemotePort(this.getIpListAsStringFromIpNetToMedia((List)macsToIpNetTOMediaMap.get(sharedmac)));
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
        return linknode;
    }

    @Override
    public Collection<BridgeLinkNode> getBridgeLinks(int nodeId) {
        ArrayList<BridgeLinkNode> bridgelinks = new ArrayList<BridgeLinkNode>();
        for (SharedSegment segment : this.m_bridgetopologyDao.getBridgeSharedSegments(nodeId)) {
            try {
                bridgelinks.add(this.convertFromModel((Integer)nodeId, segment));
            }
            catch (BridgeTopologyException e) {
                e.printStackTrace();
            }
        }
        if (bridgelinks.size() > 0) {
            Collections.sort(bridgelinks);
            LOG.debug("getBridgeLinks: node:[{}] is bridge found {} bridgelinks", (Object)nodeId, (Object)bridgelinks.size());
            return bridgelinks;
        }
        HashMap mactoIpNodeMap = new HashMap();
        this.m_ipInterfaceDao.findByNodeId(Integer.valueOf(nodeId)).stream().forEach(ip -> {
            LOG.debug("getBridgeLinks: node:[{}] is host found {} ip:{}", (Object)nodeId, (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
            this.m_ipNetToMediaDao.findByNetAddress(ip.getIpAddress()).stream().forEach(ipnettomedia -> {
                if (!mactoIpNodeMap.containsKey(ipnettomedia.getPhysAddress())) {
                    mactoIpNodeMap.put(ipnettomedia.getPhysAddress(), new ArrayList());
                }
                ((List)mactoIpNodeMap.get(ipnettomedia.getPhysAddress())).add(ip);
                LOG.debug("getBridgeLinks: node:[{}] is host found {} ip:{} mac:{}", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ip.getIpAddress()), ipnettomedia.getPhysAddress()});
            });
        });
        for (String mac : mactoIpNodeMap.keySet()) {
            SharedSegment segment = this.m_bridgetopologyDao.getHostSharedSegment(mac);
            if (segment.isEmpty()) continue;
            bridgelinks.add(this.convertFromModel(nodeId, mac, (List)mactoIpNodeMap.get(mac), segment));
        }
        Collections.sort(bridgelinks);
        return bridgelinks;
    }

    private OnmsSnmpInterface getFromCdpCacheDevicePort(Integer nodeid, String cdpCacheDevicePort) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.sql("snmpifalias = ? OR snmpifname = ? OR snmpifdescr = ?", new Object[]{cdpCacheDevicePort, cdpCacheDevicePort, cdpCacheDevicePort}, new SqlRestriction.Type[]{SqlRestriction.Type.STRING, SqlRestriction.Type.STRING, SqlRestriction.Type.STRING}).eq("node.id", (Object)nodeid);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private OnmsSnmpInterface getFromPhysAddress(String physAddress) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.eq("physAddr", (Object)physAddress);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private String getPortString(OnmsSnmpInterface snmpiface, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (snmpiface != null) {
            sb.append(snmpiface.getIfName());
            sb.append("(");
            sb.append(snmpiface.getIfAlias());
            sb.append(")");
            sb.append("(ifindex:");
            sb.append(snmpiface.getIfIndex());
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getPortString(String ifname, Integer ifindex, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (ifname != null) {
            sb.append(ifname);
        }
        if (ifindex != null) {
            sb.append("(ifindex:");
            sb.append(ifindex);
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getPortString(Integer ifindex, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (ifindex != null) {
            sb.append("(ifindex:");
            sb.append(ifindex);
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getHostString(String label, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer(label);
        if (addrtype != null && !label.equals(addr)) {
            sb.append(this.getIdString(addrtype, addr));
        }
        return sb.toString();
    }

    private String getIdString(String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (addrtype != null) {
            sb.append("(");
            if ("ip".equals(addrtype)) {
                sb.append(addr);
            } else if (addr == null) {
                sb.append(addrtype);
            } else {
                sb.append(addrtype);
                sb.append(":");
                sb.append(addr);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private String getNodeUrl(Integer nodeid) {
        return "element/linkednode.jsp?node=" + nodeid;
    }

    private String getSnmpInterfaceUrl(Integer nodeid, Integer ifindex) {
        if (ifindex != null && nodeid != null) {
            return "element/snmpinterface.jsp?node=" + nodeid + "&ifindex=" + ifindex;
        }
        return null;
    }

    private String getIpInterfaceUrl(Integer nodeid, String ipaddress) {
        return "element/interface.jsp?node=" + nodeid + "&intf=" + ipaddress;
    }

    private String getIpListAsStringFromIpInterface(List<OnmsIpInterface> ipinterfaces) {
        HashSet<String> ipstrings = new HashSet<String>();
        ipinterfaces.stream().forEach(ipinterface -> ipstrings.add(InetAddressUtils.str((InetAddress)ipinterface.getIpAddress())));
        return this.getIpList(ipstrings);
    }

    private String getIpListAsStringFromIpNetToMedia(List<IpNetToMedia> ipnettomedias) {
        HashSet<String> ipstrings = new HashSet<String>();
        ipnettomedias.stream().forEach(ipnettomedia -> ipstrings.add(InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress())));
        return this.getIpList(ipstrings);
    }

    private String getIpList(Set<String> ipstrings) {
        StringBuffer sb = new StringBuffer("(");
        boolean start = true;
        for (String ipstring : ipstrings) {
            if (start) {
                start = false;
            } else {
                sb.append(":");
            }
            sb.append(ipstring);
        }
        sb.append(")");
        return sb.toString();
    }
}

