/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.NormalizedAcknowledgeType;
import org.opennms.web.filter.NormalizedQueryParameters;
import org.opennms.web.filter.QueryParameters;
import org.opennms.web.tags.filters.FilterCallback;

public class FiltersTag
extends TagSupport {
    private static final long serialVersionUID = -8419211806241306127L;
    private static final String TEMPLATE = "{LEADING}{FILTERS}";
    private static final String FILTER_TEMPLATE = "<a class=\"btn btn-primary\" style=\"white-space:nowrap;\" href=\"{REMOVE_LINK}\" title=\"{REMOVE_LINK_TITLE}\">{FILTER_DESCRIPTION}&nbsp;&nbsp;<i class=\"fa fa-close\"></i></a>&nbsp;&nbsp;";
    private String showRemoveLink;
    private String showAcknowledgeFilter;
    private String acknowledgeFilterPrefix;
    private String acknowledgeFilterSuffix;
    private OnmsFilterFavorite favorite;
    private QueryParameters parameters;
    private FilterCallback filterCallback;
    private String context;

    public void setContext(String context) {
        if (context != null && context.startsWith("/")) {
            context = context.substring(1, context.length());
        }
        this.context = context;
    }

    public void setAcknowledgeFilterPrefix(String acknowledgeFilterPrefix) {
        this.acknowledgeFilterPrefix = acknowledgeFilterPrefix;
    }

    public void setAcknowledgeFilterSuffix(String acknowledgeFilterSuffix) {
        this.acknowledgeFilterSuffix = acknowledgeFilterSuffix;
    }

    public void setCallback(FilterCallback filterCallback) {
        this.filterCallback = filterCallback;
    }

    public void setShowAcknowledgeFilter(String showAcknowledgeFilter) {
        this.showAcknowledgeFilter = showAcknowledgeFilter;
    }

    public void setShowRemoveLink(String showRemoveLink) {
        this.showRemoveLink = showRemoveLink;
    }

    public void setParameters(QueryParameters parameters) {
        this.parameters = parameters;
    }

    public void setFavorite(OnmsFilterFavorite favorite) {
        this.favorite = favorite;
    }

    private List<Filter> getFilters() {
        if (this.parameters == null || this.parameters.getFilters() == null) {
            return new ArrayList<Filter>();
        }
        return this.parameters.getFilters();
    }

    public int doStartTag() throws JspException {
        String leadingString = this.getLeading();
        StringBuilder filterBuffer = new StringBuilder();
        for (Filter eachFilter : this.getFilters()) {
            NormalizedQueryParameters params = new NormalizedQueryParameters(this.parameters);
            params.getFilters().remove(eachFilter);
            filterBuffer.append(FILTER_TEMPLATE.replaceAll("\\{FILTER_DESCRIPTION\\}", WebSecurityUtils.sanitizeString((String)eachFilter.getTextDescription())).replaceAll("\\{REMOVE_LINK\\}", this.isShowRemoveLink() ? this.filterCallback.createLink(this.getUrlBase(), params, this.favorite) : "").replaceAll("\\{REMOVE_LINK_TITLE\\}", this.isShowRemoveLink() ? "Remove filter" : ""));
        }
        this.out(TEMPLATE.replaceAll("\\{LEADING\\}", leadingString).replaceAll("\\{FILTERS\\}", filterBuffer.toString()));
        return 1;
    }

    private void out(String content) throws JspException {
        try {
            this.pageContext.getOut().write(content);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private boolean isShowRemoveLink() {
        return Boolean.valueOf(this.showRemoveLink);
    }

    private boolean isShowAcknowledgeFilter() {
        return Boolean.valueOf(this.showAcknowledgeFilter);
    }

    private boolean isAcknowledgeType() {
        if (this.parameters != null) {
            return this.parameters.getAckType().equals((Object)NormalizedAcknowledgeType.ACKNOWLEDGED);
        }
        return false;
    }

    private boolean isUnacknowledgeType() {
        if (this.parameters != null) {
            return this.parameters.getAckType().equals((Object)NormalizedAcknowledgeType.UNACKNOWLEDGED);
        }
        return false;
    }

    private String getAcknowledgeFilterPrefix() {
        return this.acknowledgeFilterPrefix != null ? this.acknowledgeFilterPrefix : "";
    }

    private String getAcknowledgeFilterSuffix() {
        return this.acknowledgeFilterSuffix != null ? this.acknowledgeFilterSuffix : "";
    }

    private String getLeading() {
        StringBuilder leadingString = new StringBuilder();
        if (this.isShowAcknowledgeFilter()) {
            NormalizedQueryParameters params = new NormalizedQueryParameters(this.parameters);
            if (this.isAcknowledgeType()) {
                params.setAckType(NormalizedAcknowledgeType.UNACKNOWLEDGED);
                leadingString.append(FILTER_TEMPLATE.replaceAll("\\{FILTER_DESCRIPTION\\}", this.getAcknowledgeFilterPrefix() + " acknowledged").replaceAll("\\{REMOVE_LINK\\}", this.isShowRemoveLink() ? this.filterCallback.createLink(this.getUrlBase(), params, this.favorite) : "").replaceAll("\\{REMOVE_LINK_TITLE\\}", this.isShowRemoveLink() ? "Show outstanding " + this.getAcknowledgeFilterSuffix() : ""));
            } else if (this.isUnacknowledgeType()) {
                params.setAckType(NormalizedAcknowledgeType.ACKNOWLEDGED);
                leadingString.append(FILTER_TEMPLATE.replaceAll("\\{FILTER_DESCRIPTION\\}", this.getAcknowledgeFilterPrefix() + " outstanding").replaceAll("\\{REMOVE_LINK\\}", this.isShowRemoveLink() ? this.filterCallback.createLink(this.getUrlBase(), params, this.favorite) : "").replaceAll("\\{REMOVE_LINK_TITLE\\}", this.isShowRemoveLink() ? "Show acknowledged " + this.getAcknowledgeFilterSuffix() : ""));
            }
        }
        return leadingString.toString();
    }

    private String getUrlBase() {
        String urlBase = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        if (!urlBase.endsWith("/")) {
            urlBase = urlBase + "/";
        }
        return urlBase + this.context;
    }
}

