/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.support;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.rt.ReadOnlyRtConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportRtConfigDao
extends ReadOnlyRtConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(SupportRtConfigDao.class);

    protected String getPrefix() {
        return "support";
    }

    public void save() throws IOException {
        LOG.debug("saving configuration changes to {}", (Object)this.getFile());
        FileWriter fw = null;
        try {
            fw = new FileWriter(new File(this.getFile()), false);
            fw.write("# NOTE: this file is generated.  You will lose any modifications that aren't known properties!\n\n");
            if (!"https://mynms.opennms.com".equals(this.getBaseURL())) {
                fw.write("# The base URL for the OpenNMS support server.\n");
                fw.write("support.baseURL=" + this.getBaseURL() + "\n\n");
            }
            fw.write("# The support queue numeric ID to use when opening tickets\n");
            fw.write("support.queueId=" + this.getQueueId() + "\n\n");
            fw.write("# The timeout when attempting to open a ticket\n");
            fw.write("support.timeout=" + this.getTimeout() + "\n\n");
            fw.write("# The number of times to retry before giving up when opening a ticket\n");
            fw.write("support.retry=" + this.getRetry() + "\n\n");
            fw.write("# Should the system wide proxy settings be used? The system proxy settings can be configured in opennms.conf\n");
            fw.write("support.useSystemProxy=" + this.getUseSystemProxy() + "\n\n");
            if (!"OpenNMS Version".equals(this.getVersionFieldName())) {
                fw.write("support.versionFieldName=" + this.getVersionFieldName() + "\n\n");
            }
            if (!"Operating System".equals(this.getOSFieldName())) {
                fw.write("support.osFieldName=" + this.getOSFieldName() + "\n\n");
            }
            fw.flush();
            this.clearCache();
            LOG.debug("finished saving configuration changes to {}", (Object)this.getFile());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    public void setUsername(String username) {
        this.setProperty("support.username", username);
    }

    public void setPassword(String password) {
        String propertyName = "support.password";
        this.setProperty("support.password", password);
    }

    public Long getQueueId() {
        if (this.getProperties() == null) {
            return null;
        }
        try {
            return this.getProperties().getLong("support.queueId");
        }
        catch (ConversionException e) {
            return null;
        }
    }

    public void setQueueId(long queueId) {
        this.setProperty("support.queueId", queueId);
    }

    public String getBaseURL() {
        String baseUrl = this.getPrefix() + ".baseURL";
        String defaultBaseUrl = "https://mynms.opennms.com";
        return this.getStringProperty(baseUrl, "https://mynms.opennms.com");
    }

    public void setFtpBaseURL(String url) {
        this.setProperty("support.ftpBaseURL", url);
    }

    public String getFtpBaseURL() {
        return this.getStringProperty("support.ftpBaseURL", "ftp://ftp.opennms.org/incoming");
    }

    public void setVersionFieldName(String name) {
        this.setProperty("support.versionFieldName", name);
    }

    public String getVersionFieldName() {
        return this.getStringProperty("support.versionFieldName", "OpenNMS Version");
    }

    public void setOSFieldName(String name) {
        this.setProperty("support.osFieldName", name);
    }

    public String getOSFieldName() {
        return this.getStringProperty("support.osFieldName", "Operating System");
    }
}

